/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.imperial.ph.hep.command.impl;

import uk.ac.imperial.ph.hep.command.DaqBadParameterException;
import uk.ac.imperial.ph.hep.command.DaqCmdParamOption;

public class DaqCmdParamSimple
implements DaqCmdParamOption {
    private DaqCmdParamOption.Type type = DaqCmdParamOption.Type.STRING;
    private boolean on = false;
    private String eS = null;
    private String def = null;
    private String flagOnly = null;
    private boolean onlyOne = false;
    private String desc = "";
    private boolean enabled = true;

    public DaqCmdParamSimple(String string, boolean bl, DaqCmdParamOption.Type type, String[] stringArray, String string2) {
        this.flagOnly = string;
        this.def = string;
        this.eS = string;
        this.onlyOne = bl;
        this.type = type;
        this.setOptValues(stringArray);
        this.eS = this.def = this.getExecString();
        this.desc = string2;
    }

    public DaqCmdParamSimple(String string, DaqCmdParamOption.Type type, String string2, String string3) {
        this.flagOnly = string;
        this.def = string;
        this.eS = string;
        this.onlyOne = true;
        this.type = type;
        String[] stringArray = new String[]{string2};
        this.setOptValues(stringArray);
        this.eS = this.def = this.getExecString();
        this.desc = string3;
    }

    @Override
    public DaqCmdParamOption.Type getOptType() {
        return this.type;
    }

    @Override
    public boolean oneOptOnly() {
        return this.onlyOne;
    }

    @Override
    public void setOptValues(String[] stringArray) throws DaqBadParameterException {
        if (this.onlyOne && stringArray.length > 1) {
            throw new DaqBadParameterException("More than one option was specified for the parameter.");
        }
        this.eS = this.flagOnly;
        for (String string : stringArray) {
            if (this.type == DaqCmdParamOption.Type.INT) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DaqBadParameterException("Expected option parameter of type int, got " + string);
                }
            }
            if (this.type == DaqCmdParamOption.Type.CHAR && string.length() > 1) {
                throw new DaqBadParameterException("Parameter option was too large  - expected char, got " + string);
            }
            this.eS = this.eS + " " + string;
        }
        this.on = true;
    }

    @Override
    public String getExecString() {
        if (this.on) {
            return this.eS;
        }
        return "";
    }

    @Override
    public boolean isUnaltered() {
        return this.eS.equals(this.def);
    }

    @Override
    public void reset() {
        this.eS = this.def;
        this.enabled = true;
    }

    @Override
    public void setOff() {
        this.on = false;
    }

    @Override
    public void setOn() {
        this.on = true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }
}

