/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.imperial.ph.hep.command.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import uk.ac.imperial.ph.hep.command.DaqCmdListener;
import uk.ac.imperial.ph.hep.command.DaqCommand;
import uk.ac.imperial.ph.hep.command.impl.DaqLogCmd;
import uk.ac.imperial.ph.hep.service.DaqApplication;

public class DaqLogFileCmd
extends DaqLogCmd {
    Thread processWatcher = null;
    private boolean running = false;
    private String filename = null;

    private DaqLogFileCmd() {
    }

    public DaqLogFileCmd(String string) {
        this.filename = string;
    }

    @Override
    public void execute() {
        this.startWatchingFile(this.filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        if (this.processWatcher != null) {
            Thread thread = this.processWatcher;
            synchronized (thread) {
                this.processWatcher.interrupt();
            }
        }
        this.running = false;
        DaqApplication.getApp().getLogger().fine("Ending execution");
    }

    public static void main(String[] stringArray) throws Exception {
        DaqLogFileCmd daqLogFileCmd = new DaqLogFileCmd("/home/jamie/nvidia_note");
        daqLogFileCmd.registerListener(new DaqCmdListener(){

            @Override
            public void outputReceived(String string) {
                System.out.println(string);
            }
        });
        ((DaqCommand)daqLogFileCmd).execute();
        Thread.sleep(10000L);
        ((DaqCommand)daqLogFileCmd).terminate();
    }

    private void startWatchingFile(final String string) {
        this.processWatcher = new Thread(){
            Process p = null;
            BufferedReader stdInput = null;

            @Override
            public void run() {
                DaqLogFileCmd.this.notifyListeners("Log file watcher: Starting file watch of " + string);
                try {
                    String string2;
                    this.p = Runtime.getRuntime().exec("/usr/bin/tail " + string);
                    this.stdInput = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
                    while ((string2 = this.stdInput.readLine()) != null) {
                        DaqLogFileCmd.this.notifyListeners(string2);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            @Override
            public void interrupt() {
                DaqLogFileCmd.this.notifyListeners("Log file watcher: Stopping file watch");
                this.p.destroy();
                try {
                    this.stdInput.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        this.processWatcher.start();
        this.running = true;
        System.out.println("Sucessfully started file watching thread");
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public String toString() {
        return "Watches log files";
    }
}

