/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.imperial.ph.hep.command.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.logging.Level;
import uk.ac.imperial.ph.hep.command.impl.DaqLogCmd;
import uk.ac.imperial.ph.hep.service.DaqApplication;
import uk.ac.imperial.ph.hep.service.DaqService;

public class DaqRunMonitor
extends DaqLogCmd {
    Thread runMonitorThread = null;
    boolean isRunning = false;

    private String getExecString() {
        return "/home/caliceon/online/bin/runMonitor";
    }

    @Override
    public void execute() {
        DaqApplication.getApp().getLogger().fine("runMonitor - Starting execution");
        this.notifyListeners("runMonitor starting up...");
        this.runMonitorThread = new Thread(){
            Process p = null;
            BufferedReader stdInput = null;

            @Override
            public void run() {
                try {
                    String string;
                    this.p = Runtime.getRuntime().exec(DaqRunMonitor.this.getExecString(), DaqService.getDaqService().getRuntimeEnvironment());
                    this.stdInput = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
                    while ((string = this.stdInput.readLine()) != null) {
                        DaqRunMonitor.this.notifyListeners(string);
                    }
                }
                catch (IOException iOException) {
                    DaqApplication.getApp().getLogger().fine("runMonitor thread encountered an IOException: " + iOException.getMessage());
                }
            }

            @Override
            public void interrupt() {
                if (this.p != null) {
                    this.p.destroy();
                    try {
                        DaqApplication.getApp().getLogger().info("runMonitor closed with exitValue: " + this.p.exitValue());
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        DaqApplication.getApp().getLogger().info("runMonitor process wouldn't destroy, doing dirty cleanup...");
                        try {
                            Class<?> clazz = this.p.getClass();
                            Field field = clazz.getDeclaredField("pid");
                            field.setAccessible(true);
                            DaqApplication.getApp().getLogger().info("kill runMonitor with process pid: " + field.getInt(this.p));
                            Runtime.getRuntime().exec("/usr/bin/kill -9 " + field.getInt(this.p));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                DaqApplication.getApp().getLogger().log(Level.INFO, "Sucessfully and quietly closed file watching process");
            }
        };
        this.runMonitorThread.start();
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.notifyListeners("runMonitor closing up...");
        if (this.runMonitorThread != null) {
            Thread thread = this.runMonitorThread;
            synchronized (thread) {
                this.runMonitorThread.interrupt();
            }
        }
        this.isRunning = false;
        DaqApplication.getApp().getLogger().fine("runMonitor - Ending execution");
    }

    @Override
    public String toString() {
        return "Executes the runMonitor command.";
    }
}

