/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.imperial.ph.hep.command.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import uk.ac.imperial.ph.hep.command.DaqCmdParam;
import uk.ac.imperial.ph.hep.command.DaqCmdParamOnOff;
import uk.ac.imperial.ph.hep.command.DaqCmdParamOption;
import uk.ac.imperial.ph.hep.command.DaqCommand;
import uk.ac.imperial.ph.hep.command.impl.DaqCmdParamSimple;
import uk.ac.imperial.ph.hep.service.DaqApplication;
import uk.ac.imperial.ph.hep.service.DaqService;

public class DaqStartRunCmd
extends DaqCommand {
    private Thread t = null;
    private Map<String, DaqCmdParam> params = new HashMap<String, DaqCmdParam>();
    private Map<String, DaqCmdParamOption> optParams = new HashMap<String, DaqCmdParamOption>();

    public DaqStartRunCmd() {
        this.params.put("w", new DaqCmdParamOnOff("+w", "-w", "Make output file"));
        this.params.put("a", new DaqCmdParamOnOff("-a", "+a", "Ascii output file"));
        this.params.put("d", new DaqCmdParamOnOff("+d", "-d", "Enable displays"));
        this.params.put("i", new DaqCmdParamOnOff("+i", "-i", "Interrupt runner"));
        this.optParams.put("t", new DaqCmdParamSimple("-t", DaqCmdParamOption.Type.STRING, "crcNoise", "Run type"));
        this.optParams.put("v", new DaqCmdParamSimple("-v", DaqCmdParamOption.Type.INT, "5", "Run type version"));
        this.optParams.put("n", new DaqCmdParamSimple("-n", DaqCmdParamOption.Type.INT, "1", "Number of runs"));
        this.optParams.put("p", new DaqCmdParamSimple("-p", DaqCmdParamOption.Type.INT, "9", "Print level"));
        this.optParams.put("s", new DaqCmdParamSimple("-s", DaqCmdParamOption.Type.INT, "2147483647", "Max run time"));
        this.optParams.put("c", new DaqCmdParamSimple("-c", DaqCmdParamOption.Type.INT, "2147483647", "Max number of configurations"));
        this.optParams.put("b", new DaqCmdParamSimple("-b", DaqCmdParamOption.Type.INT, "2147483647", "Max number of bunches"));
    }

    @Override
    public void execute() {
        super.notifyListeners("runStart command being issued.");
        this.t = new Thread(){
            Process p = null;
            BufferedReader stdInput = null;

            @Override
            public void run() {
                DaqApplication.getApp().getLogger().info("runStart command -  thread starting.");
                DaqStartRunCmd.this.notifyListeners("Sending: " + DaqStartRunCmd.this.getExecString());
                try {
                    String string;
                    DaqApplication.getApp().getLogger().info("Executing: " + DaqStartRunCmd.this.getExecString());
                    this.p = Runtime.getRuntime().exec(DaqStartRunCmd.this.getExecString(), DaqService.getDaqService().getRuntimeEnvironment());
                    this.stdInput = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
                    while ((string = this.stdInput.readLine()) != null) {
                        DaqStartRunCmd.this.notifyListeners(string);
                        DaqApplication.getApp().getLogger().fine("runStart command: " + string);
                    }
                    this.stdInput.close();
                    DaqApplication.getApp().getLogger().info("runStart command - thread ending.");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            @Override
            public void interrupt() {
                DaqStartRunCmd.this.notifyListeners("Stopping startRun command.");
                this.p.destroy();
                try {
                    this.stdInput.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                DaqApplication.getApp().getLogger().info("Sucessfully and quietly closed runStart process");
            }
        };
        this.t.start();
    }

    private String getExecString() {
        String string = DaqService.getDaqService().getCmdPath() + "runStart";
        for (DaqCmdParam daqCmdParam : this.params.values()) {
            if (daqCmdParam.isUnaltered() || !daqCmdParam.isEnabled()) continue;
            string = string + " " + daqCmdParam.getExecString();
        }
        for (DaqCmdParamOption daqCmdParamOption : this.optParams.values()) {
            if (daqCmdParamOption.isUnaltered() || !daqCmdParamOption.isEnabled()) continue;
            string = string + " " + daqCmdParamOption.getExecString();
        }
        return string;
    }

    @Override
    public String getDescription() {
        return "General purpose startRun cmd";
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void terminate() {
        super.notifyListeners("Terminating startRun command");
    }

    public DaqCmdParam getOnOffParameter(String string) {
        return this.params.get(string);
    }

    public DaqCmdParamOption getParameterWithOptions(String string) {
        return this.optParams.get(string);
    }

    @Override
    public String toString() {
        return this.getExecString();
    }
}

