/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.imperial.ph.hep.datamodel;

import java.util.Date;
import java.util.logging.Logger;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import uk.ac.imperial.ph.hep.command.DaqBadParameterException;
import uk.ac.imperial.ph.hep.command.DaqCommand;
import uk.ac.imperial.ph.hep.command.impl.DaqStartRunCmd;

@Entity
public class CandidateRun
implements Cloneable {
    public final int MAX_NO_CONFIGS = Integer.MAX_VALUE;
    public final int MAX_NO_BUNCHES = Integer.MAX_VALUE;
    public final int MAX_RUN_TIME = Integer.MAX_VALUE;
    private String majorVersion = null;
    private String domain = null;
    private String runType = null;
    private String version = null;
    private int numberOfRuns = 1;
    private int printLevel = 9;
    private int maxRunTime = Integer.MAX_VALUE;
    private int maxNumberOfConfigs = Integer.MAX_VALUE;
    private int maxNumberOfBunches = Integer.MAX_VALUE;
    private boolean outputFile = true;
    private boolean asciiOutput = false;
    private boolean displays = true;
    private boolean interruptRunner = true;
    private Date createdOn;
    public Long id;
    public static final int N_RUNS_OPT = 0;
    public static final int PRINT_LEVEL_OPT = 1;
    public static final int MAX_TIME_OPT = 2;
    public static final int MAX_CONFIGS_OPT = 3;
    public static final int MAX_BUNCHES_OPT = 4;
    public static final int VERSION_OPT = 5;
    public static final int OUTPUT_OPT = 6;
    public static final int ASCII_OPT = 7;
    public static final int DISPLAYS_OPT = 8;
    public static final int INTERRUPT_OPT = 9;

    private CandidateRun() {
    }

    public CandidateRun(String string, String string2, String string3, String string4) {
        this.majorVersion = string;
        this.domain = string2;
        this.runType = string3;
        this.version = string4;
        this.createdOn = new Date();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    private void setId(Long l) {
        this.id = l;
    }

    public boolean isAsciiOutput() {
        return this.asciiOutput;
    }

    public void setAsciiOutput(boolean bl) {
        this.asciiOutput = bl;
    }

    public int getMaxNumberOfBunches() {
        return this.maxNumberOfBunches;
    }

    public void setMaxNumberOfBunches(int n) {
        if (n > Integer.MAX_VALUE) {
            throw new DaqBadParameterException("Attempt to set max no bunches > 2147483647");
        }
        if (n < 1) {
            throw new DaqBadParameterException("Attempt to set max no bunches < 1");
        }
        this.maxNumberOfBunches = n;
    }

    public int getMaxNumberOfConfigs() {
        return this.maxNumberOfConfigs;
    }

    public void setMaxNumberOfConfigs(int n) {
        if (n > Integer.MAX_VALUE) {
            throw new DaqBadParameterException("Attempt to set the max number of configs > than MAX_NO_CONFIGS = 2147483647");
        }
        if (n < 1) {
            throw new DaqBadParameterException("Attempt to set max no configs < 1");
        }
        this.maxNumberOfConfigs = n;
    }

    public int getMaxRunTime() {
        return this.maxRunTime;
    }

    public void setMaxRunTime(int n) {
        if (n > Integer.MAX_VALUE) {
            throw new DaqBadParameterException("Attempt to run for longer than MAX_RUN_TIME = 2147483647");
        }
        if (n < 1) {
            throw new DaqBadParameterException("Attempt to set max run time < 1");
        }
        this.maxRunTime = n;
    }

    public int getNumberOfRuns() {
        return this.numberOfRuns;
    }

    public void setNumberOfRuns(int n) {
        if (n < 1) {
            throw new DaqBadParameterException("Attempt to set number of runs < 1");
        }
        this.numberOfRuns = n;
    }

    public boolean isOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(boolean bl) {
        this.outputFile = bl;
    }

    public int getPrintLevel() {
        return this.printLevel;
    }

    public void setPrintLevel(int n) {
        if (n < 0) {
            throw new DaqBadParameterException("Print level set to a value < 0.");
        }
        this.printLevel = n;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getRunType() {
        return this.runType;
    }

    @Transient
    public DaqCommand getDaqCommand() {
        DaqStartRunCmd daqStartRunCmd = new DaqStartRunCmd();
        if (!this.isOutputFile()) {
            daqStartRunCmd.getOnOffParameter("w").setOn();
        }
        if (this.isAsciiOutput()) {
            daqStartRunCmd.getOnOffParameter("a").setOn();
        }
        if (!this.isDisplays()) {
            daqStartRunCmd.getOnOffParameter("d").setOn();
        }
        if (!this.isInterruptRunner()) {
            daqStartRunCmd.getOnOffParameter("i").setOn();
        }
        String[] stringArray = new String[]{this.getRunType()};
        daqStartRunCmd.getParameterWithOptions("t").setOptValues(stringArray);
        String[] stringArray2 = new String[]{this.getVersion()};
        daqStartRunCmd.getParameterWithOptions("v").setOptValues(stringArray2);
        String[] stringArray3 = new String[]{Integer.toString(this.getPrintLevel())};
        daqStartRunCmd.getParameterWithOptions("p").setOptValues(stringArray3);
        String[] stringArray4 = new String[]{Integer.toString(this.getMaxRunTime())};
        daqStartRunCmd.getParameterWithOptions("s").setOptValues(stringArray4);
        String[] stringArray5 = new String[]{Integer.toString(this.getMaxNumberOfConfigs())};
        daqStartRunCmd.getParameterWithOptions("c").setOptValues(stringArray5);
        String[] stringArray6 = new String[]{Integer.toString(this.getMaxNumberOfBunches())};
        daqStartRunCmd.getParameterWithOptions("b").setOptValues(stringArray6);
        String[] stringArray7 = new String[]{Integer.toString(this.getNumberOfRuns())};
        daqStartRunCmd.getParameterWithOptions("n").setOptValues(stringArray7);
        return daqStartRunCmd;
    }

    public boolean isDisplays() {
        return this.displays;
    }

    public void setDisplays(boolean bl) {
        this.displays = bl;
    }

    public boolean isInterruptRunner() {
        return this.interruptRunner;
    }

    public void setInterruptRunner(boolean bl) {
        this.interruptRunner = bl;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreatedOn() {
        return this.createdOn;
    }

    private void setCreatedOn(Date date) {
        this.createdOn = date;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Logger.getLogger("maps.daq").severe("Failed to clone a CandidateRun! " + cloneNotSupportedException.getMessage());
            cloneNotSupportedException.printStackTrace();
        }
        return object;
    }

    public String toString() {
        return "CandidateRun: created " + this.createdOn.toString() + ", with type " + this.getRunType();
    }

    private void setDomain(String string) {
        this.domain = string;
    }

    private void setRunType(String string) {
        this.runType = string;
    }

    private void setMajorVersion(String string) {
        this.majorVersion = string;
    }
}

