/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.imperial.ph.hep.gui;

import java.io.IOException;
import java.text.Collator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import uk.ac.imperial.ph.hep.command.DaqCmdListener;
import uk.ac.imperial.ph.hep.command.DaqCommand;
import uk.ac.imperial.ph.hep.command.impl.DaqLogMonitor;
import uk.ac.imperial.ph.hep.datamodel.CandidateRun;
import uk.ac.imperial.ph.hep.service.DaqApplication;
import uk.ac.imperial.ph.hep.service.DaqRunChangedListener;
import uk.ac.imperial.ph.hep.service.DaqService;
import uk.ac.imperial.ph.hep.service.DaqStatusException;
import uk.ac.imperial.ph.hep.service.DaqStatusListener;
import uk.ac.imperial.ph.hep.service.Util;

public class DaqGuiControl {
    private DaqApplication app = null;
    private Display disp = null;
    private Shell shell = null;
    private CTabFolder crEditor = null;
    private CTabFolder monitors = null;
    private CoolBar coolBar = null;
    private Group runEditorGroup = null;
    private Group runTypesGroup = null;
    private Group monitorGroup = null;
    private Button toggleWatchBtn = null;
    private Button freezeScrollBtn = null;
    private Label currentRunLbl = null;
    private Text textAr = null;
    private Text guiMsgAr = null;
    private Table typeTable = null;
    private boolean freezeOn = false;
    private DaqCommand runMonitor = new DaqLogMonitor("/home/caliceon/online/data/log/ActiveLog.out");
    private DaqCommand guiLogMonitor = new DaqLogMonitor("guiLog.txt");
    private final int N_COLS = 4;
    private final String FREEZE = "Freeze scrolling";
    private final String RESUME = "Resume";
    private int lineCount = 0;
    private String[] columnNames = new String[]{"Major version", "Domain", "Run type", "Version number"};

    public DaqGuiControl(DaqApplication daqApplication) {
        daqApplication.getLogger().log(Level.FINE, "Setting up Gui...");
        this.disp = new Display();
        this.shell = new Shell(this.disp, 1264);
        this.app = daqApplication;
        this.setupGui();
    }

    public void setupGui() {
        this.shell.setText("Run Control - " + this.app.getAppTitle());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.shell.setLayout((Layout)gridLayout);
        this.getCoolBar((Composite)this.shell);
        this.runTypesGroup = this.getRunTypeGroup((Composite)this.shell);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        this.runTypesGroup.setLayoutData((Object)gridData);
        this.runTypesGroup.pack();
        this.getRunEditorGroup((Composite)this.shell);
        GridData gridData2 = new GridData(256);
        gridData2.horizontalSpan = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = false;
        this.runEditorGroup.setLayoutData((Object)gridData2);
        this.runEditorGroup.pack();
        this.getMonitorGroup((Composite)this.shell);
        GridData gridData3 = new GridData(272);
        gridData3.horizontalSpan = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.grabExcessVerticalSpace = true;
        this.monitorGroup.setLayoutData((Object)gridData3);
        this.monitorGroup.pack();
        this.shell.setImage(DaqService.getDaqService().getStatus().getAppIcon().getIcon(this.disp));
        DaqService.getDaqService().registerDaqStatusListener(new DaqStatusListener(){

            @Override
            public void newStatus(DaqService.DaqStatus daqStatus) {
                DaqGuiControl.this.shell.setImage(daqStatus.getAppIcon().getIcon(DaqGuiControl.this.disp));
            }
        });
        this.shell.pack();
        this.shell.setSize(800, 800);
        this.shell.open();
        this.app.getLogger().log(Level.FINE, "Finished drawing Gui.");
    }

    private Group getRunEditorGroup(Composite composite) {
        if (this.runEditorGroup == null) {
            this.runEditorGroup = new Group(composite, 2048);
            this.runEditorGroup.setText("Run dispatch and control");
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 7;
            this.runEditorGroup.setLayout((Layout)gridLayout);
            this.crEditor = this.getCandidateRunEditor((Composite)this.runEditorGroup);
            GridData gridData = new GridData(256);
            gridData.horizontalSpan = 7;
            gridData.grabExcessHorizontalSpace = true;
            this.crEditor.setLayoutData((Object)gridData);
            this.makeStartRunButton((Composite)this.runEditorGroup, true).setSize(100, 40);
            this.makeEndConfigBtn((Composite)this.runEditorGroup, true);
            this.makeEndSeqBtn((Composite)this.runEditorGroup, true);
            this.makeEndRunBtn((Composite)this.runEditorGroup, true);
            DaqService daqService = DaqService.getDaqService();
            daqService.refreshStatus();
            final Label label = new Label((Composite)this.runEditorGroup, 0);
            label.setImage(daqService.getStatus().getAppIcon().getIcon(this.disp));
            final Label label2 = new Label((Composite)this.runEditorGroup, 0);
            label2.setText(daqService.getStatus().getInterpretation() + "               ");
            GridData gridData2 = new GridData(256);
            label2.setLayoutData((Object)gridData2);
            daqService.registerDaqStatusListener(new DaqStatusListener(){

                @Override
                public void newStatus(DaqService.DaqStatus daqStatus) {
                    label.setImage(daqStatus.getAppIcon().getIcon(DaqGuiControl.this.disp));
                    label2.setText(daqStatus.getInterpretation());
                }
            });
        }
        return this.runEditorGroup;
    }

    private Group getMonitorGroup(Composite composite) {
        if (this.monitorGroup == null) {
            this.monitorGroup = new Group(composite, 2048);
            this.monitorGroup.setText("Output monitoring");
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            this.monitorGroup.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(256);
            gridData.grabExcessHorizontalSpace = true;
            this.getToggleWatchBtn((Composite)this.monitorGroup, true, true);
            this.currentRunLbl = new Label((Composite)this.monitorGroup, 0);
            this.currentRunLbl.setText("<No run to report>");
            DaqService.getDaqService().registerDaqRunChangedListener(new DaqRunChangedListener(){

                @Override
                public void newRun(int n) {
                    if (n > 2) {
                        DaqGuiControl.this.currentRunLbl.setText("Run:" + n);
                    } else {
                        DaqGuiControl.this.currentRunLbl.setText("<No run>");
                    }
                }
            });
            this.getMonitors((Composite)this.monitorGroup);
            GridData gridData2 = new GridData(272);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.grabExcessVerticalSpace = true;
            gridData2.horizontalSpan = 4;
            this.monitors.setLayoutData((Object)gridData2);
        }
        return this.monitorGroup;
    }

    private Group getRunTypeGroup(Composite composite) {
        if (this.runTypesGroup == null) {
            this.runTypesGroup = new Group(composite, 2048);
            this.runTypesGroup.setText("Runs advertised");
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            this.runTypesGroup.setLayout((Layout)gridLayout);
            ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.runTypesGroup, 768);
            Table table = this.getTypeTable((Composite)scrolledComposite);
            table.setSize(200, 150);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setContent((Control)table);
            GridData gridData = new GridData(256);
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = false;
            scrolledComposite.setLayoutData((Object)gridData);
        }
        return this.runTypesGroup;
    }

    private CTabFolder getCandidateRunEditor(Composite composite) {
        if (this.crEditor == null) {
            this.crEditor = new CTabFolder(composite, 2048);
            this.crEditor.setLayoutData((Object)new GridData(4, 4, true, false));
            this.crEditor.setSimple(false);
            this.crEditor.setUnselectedCloseVisible(true);
            this.crEditor.setUnselectedImageVisible(false);
        }
        return this.crEditor;
    }

    private CTabFolder getMonitors(Composite composite) {
        if (this.monitors == null) {
            this.monitors = new CTabFolder(composite, 2048);
            this.monitors.setLayoutData((Object)new GridData(4, 4, true, false));
            this.monitors.setSimple(false);
            this.monitors.setUnselectedCloseVisible(false);
            this.monitors.setUnselectedImageVisible(false);
            CTabItem cTabItem = new CTabItem(this.monitors, 0);
            cTabItem.setText("Loggage");
            ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.monitors, 512);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            Composite composite2 = new Composite((Composite)scrolledComposite, 0);
            scrolledComposite.setContent((Control)composite2);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            composite2.setLayout((Layout)gridLayout);
            this.getLogArea(composite2);
            composite2.pack();
            scrolledComposite.setMinSize(composite2.computeSize(-1, -1));
            cTabItem.setControl((Control)scrolledComposite);
            cTabItem.setImage(DaqApplication.AppIcon.RUN.getIcon(this.disp));
            CTabItem cTabItem2 = new CTabItem(this.monitors, 0);
            cTabItem2.setText("Gui Message Area");
            ScrolledComposite scrolledComposite2 = new ScrolledComposite((Composite)this.monitors, 512);
            scrolledComposite2.setExpandHorizontal(true);
            scrolledComposite2.setExpandVertical(true);
            Composite composite3 = new Composite((Composite)scrolledComposite2, 0);
            scrolledComposite2.setContent((Control)composite3);
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.numColumns = 1;
            composite3.setLayout((Layout)gridLayout2);
            this.getGuiMessageArea(composite3);
            composite3.pack();
            scrolledComposite2.setMinSize(composite3.computeSize(-1, -1));
            cTabItem2.setControl((Control)scrolledComposite2);
            this.monitors.setSelection(cTabItem);
            this.shell.layout();
        }
        return this.monitors;
    }

    private Table getTypeTable(Composite composite) {
        if (this.typeTable == null) {
            this.typeTable = new Table(composite, 2048);
            this.typeTable.setHeaderVisible(true);
            int n = 0;
            while (n < this.columnNames.length) {
                TableColumn tableColumn = new TableColumn(this.typeTable, 0);
                tableColumn.setText(this.columnNames[n]);
                tableColumn.setWidth(150);
                final int n2 = n++;
                tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        TableItem[] tableItemArray = DaqGuiControl.this.typeTable.getItems();
                        int n = 0;
                        Collator collator = Collator.getInstance(Locale.getDefault());
                        block0: for (int i = 1; i < tableItemArray.length; ++i) {
                            String string = tableItemArray[i].getText(n2);
                            for (int j = 0; j < i; ++j) {
                                String string2 = tableItemArray[j].getText(n2);
                                n = n2 == 1 || n2 == 2 ? collator.compare(string, string2) : Integer.parseInt(string) - Integer.parseInt(string2);
                                if (n >= 0) continue;
                                String[] stringArray = new String[]{tableItemArray[i].getText(0), tableItemArray[i].getText(1), tableItemArray[i].getText(2), tableItemArray[i].getText(3)};
                                TableItem tableItem = new TableItem(DaqGuiControl.this.typeTable, 0, j);
                                tableItem.setText(stringArray);
                                tableItem.setData(tableItemArray[i].getData());
                                tableItemArray[i].dispose();
                                tableItemArray = DaqGuiControl.this.typeTable.getItems();
                                continue block0;
                            }
                        }
                    }
                });
            }
            this.typeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    TableItem[] tableItemArray = DaqGuiControl.this.typeTable.getSelection();
                    if (tableItemArray.length > 0) {
                        DaqGuiControl.this.addCandidateRunTab((CandidateRun)tableItemArray[0].getData());
                    }
                }
            });
        }
        return this.typeTable;
    }

    protected void addCandidateRunTab(CandidateRun candidateRun) {
        final CandidateRun candidateRun2 = (CandidateRun)candidateRun.clone();
        CTabItem cTabItem = new CTabItem(this.crEditor, 64);
        cTabItem.setText(candidateRun2.getDomain() + "/" + candidateRun2.getRunType());
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.crEditor, 512);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        final Button button = new Button(composite, 32);
        button.setText("Create output file");
        button.setSelection(candidateRun2.isOutputFile());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                candidateRun2.setOutputFile(button.getSelection());
            }
        });
        final Button button2 = new Button(composite, 32);
        button2.setText("Displays on");
        button2.setSelection(candidateRun2.isDisplays());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                candidateRun2.setDisplays(button2.getSelection());
            }
        });
        final Button button3 = new Button(composite, 32);
        button3.setText("Interrupt runner");
        button3.setSelection(candidateRun2.isInterruptRunner());
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                candidateRun2.setInterruptRunner(button3.getSelection());
            }
        });
        Label label = new Label(composite, 0);
        HashMap<Integer, Text> hashMap = new HashMap<Integer, Text>();
        hashMap.put(5, this.addKeyValPairToTab("Version number: ", candidateRun2.getVersion(), composite));
        hashMap.put(0, this.addKeyValPairToTab("Number of runs: ", Integer.toString(candidateRun2.getNumberOfRuns()), composite));
        hashMap.put(1, this.addKeyValPairToTab("Print level: ", Integer.toString(candidateRun2.getPrintLevel()), composite));
        hashMap.put(2, this.addKeyValPairToTab("Max run time (seconds): ", Integer.toString(candidateRun2.getMaxRunTime()), composite));
        hashMap.put(3, this.addKeyValPairToTab("Max number of configs: ", Integer.toString(candidateRun2.getMaxNumberOfConfigs()), composite));
        hashMap.put(4, this.addKeyValPairToTab("Max number of bunches: ", Integer.toString(candidateRun2.getMaxNumberOfBunches()), composite));
        for (Integer n : hashMap.keySet()) {
            this.addUpdateCandRunListener((Text)hashMap.get(n), candidateRun2, n);
        }
        composite.pack();
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        cTabItem.setControl((Control)scrolledComposite);
        cTabItem.setData((Object)candidateRun2);
        cTabItem.setImage(DaqApplication.AppIcon.RUN.getIcon(this.disp));
        this.crEditor.setSelection(cTabItem);
        this.shell.layout();
    }

    private Text addKeyValPairToTab(String string, String string2, Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(string);
        Text text = new Text(composite, 2052);
        text.setText(string2);
        GridData gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        return text;
    }

    private void addUpdateCandRunListener(final Text text, final CandidateRun candidateRun, final int n) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                try {
                    Integer.parseInt(text.getText());
                    if (n == 4) {
                        candidateRun.setMaxNumberOfBunches(Integer.parseInt(text.getText()));
                    } else if (n == 3) {
                        candidateRun.setMaxNumberOfConfigs(Integer.parseInt(text.getText()));
                    } else if (n == 5) {
                        candidateRun.setVersion(text.getText());
                    } else if (n == 1) {
                        candidateRun.setPrintLevel(Integer.parseInt(text.getText()));
                    } else if (n == 2) {
                        candidateRun.setMaxRunTime(Integer.parseInt(text.getText()));
                    } else if (n == 0) {
                        candidateRun.setNumberOfRuns(Integer.parseInt(text.getText()));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    DaqGuiControl.this.app.getLogger().info("Invalid value specified for runStart command - integer expected!");
                }
            }
        });
    }

    private void populateTypeTable(String string) {
        this.typeTable.clearAll();
        this.typeTable.removeAll();
        try {
            List<CandidateRun> list = Util.getAvailableRunType(string);
            for (CandidateRun candidateRun : list) {
                TableItem tableItem = new TableItem(this.typeTable, 0);
                tableItem.setData((Object)candidateRun);
                String[] stringArray = new String[]{candidateRun.getMajorVersion(), candidateRun.getDomain(), candidateRun.getRunType(), candidateRun.getVersion()};
                tableItem.setText(stringArray);
            }
        }
        catch (IOException iOException) {
            this.app.getLogger().warning("Tried to load file " + string + " but failed. IOException was: " + iOException.getMessage());
            iOException.printStackTrace();
            MessageBox messageBox = new MessageBox(this.shell, 33);
            messageBox.setText("Error - " + this.app.getAppTitle());
            messageBox.setMessage("The file could not be read. Please check logs.");
            messageBox.open();
        }
        catch (RuntimeException runtimeException) {
            this.app.getLogger().warning("A runtime error occurred while loading " + string + ". It's likely the file format is invalid. Exception was: " + runtimeException.getMessage());
            MessageBox messageBox = new MessageBox(this.shell, 33);
            messageBox.setText("Error - " + this.app.getAppTitle());
            messageBox.setMessage("The file format could not be understood. Please check logs.");
            messageBox.open();
        }
    }

    private CoolBar getCoolBar(Composite composite) {
        if (this.coolBar == null) {
            this.coolBar = new CoolBar(composite, 0);
            this.coolBar.setLayout((Layout)new GridLayout());
            ToolBar toolBar = new ToolBar((Composite)this.coolBar, 0x800000);
            ToolItem toolItem = new ToolItem(toolBar, 0);
            toolItem.setImage(DaqApplication.AppIcon.OPEN_RUN_DESCS.getIcon(this.disp));
            toolItem.setToolTipText(DaqApplication.AppIcon.OPEN_RUN_DESCS.getTooltipText());
            toolItem.addSelectionListener((SelectionListener)this.getListenerForRunDescs(this.shell));
            ToolItem toolItem2 = new ToolItem(toolBar, 0);
            toolItem2.setImage(DaqApplication.AppIcon.DAQ_START.getIcon(this.disp));
            toolItem2.setToolTipText(DaqApplication.AppIcon.DAQ_START.getTooltipText());
            toolItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DaqService.getDaqService().startup();
                }
            });
            ToolItem toolItem3 = new ToolItem(toolBar, 0);
            toolItem3.setImage(DaqApplication.AppIcon.DAQ_STOP.getIcon(this.disp));
            toolItem3.setToolTipText(DaqApplication.AppIcon.DAQ_STOP.getTooltipText());
            toolItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DaqService.getDaqService().shutdown();
                }
            });
            ToolItem toolItem4 = new ToolItem(toolBar, 0);
            toolItem4.setImage(DaqApplication.AppIcon.DAQ_PANIC.getIcon(this.disp));
            toolItem4.setToolTipText(DaqApplication.AppIcon.DAQ_PANIC.getTooltipText());
            toolItem4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DaqService.getDaqService().panic();
                }
            });
            ToolItem toolItem5 = new ToolItem(toolBar, 0);
            toolItem5.setImage(DaqApplication.AppIcon.DAQ_REFRESH.getIcon(this.disp));
            toolItem5.setToolTipText(DaqApplication.AppIcon.DAQ_REFRESH.getTooltipText());
            toolItem5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DaqService.getDaqService().refreshStatus();
                }
            });
            CoolItem coolItem = new CoolItem(this.coolBar, 0);
            coolItem.setControl((Control)toolBar);
            Point point = toolBar.computeSize(-1, -1);
            toolBar.setSize(point);
            Point point2 = coolItem.computeSize(point.x, point.y + 10);
            coolItem.setSize(point2);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.coolBar.setLayoutData((Object)gridData);
        }
        return this.coolBar;
    }

    private Button getToggleWatchBtn(Composite composite, final boolean bl, final boolean bl2) {
        if (this.toggleWatchBtn == null) {
            this.toggleWatchBtn = new Button(composite, 8);
            this.toggleWatchBtn.setToolTipText(DaqApplication.AppIcon.LOG_START.getTooltipText());
            if (bl2) {
                this.toggleWatchBtn.setText(DaqApplication.AppIcon.LOG_START.getTooltipText());
            }
            if (bl) {
                this.toggleWatchBtn.setImage(DaqApplication.AppIcon.LOG_START.getIcon(this.disp));
            }
            this.toggleWatchBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DaqGuiControl.this.app.getLogger().log(Level.FINE, "Daq Log button invoked - intending to " + DaqGuiControl.this.toggleWatchBtn.getText());
                    if (DaqGuiControl.this.toggleWatchBtn.getToolTipText() == DaqApplication.AppIcon.LOG_START.getTooltipText()) {
                        DaqGuiControl.this.toggleWatchBtn.setToolTipText(DaqApplication.AppIcon.LOG_STOP.getTooltipText());
                        if (bl2) {
                            DaqGuiControl.this.toggleWatchBtn.setText(DaqApplication.AppIcon.LOG_STOP.getTooltipText());
                        }
                        if (bl) {
                            DaqGuiControl.this.toggleWatchBtn.setImage(DaqApplication.AppIcon.LOG_STOP.getIcon(DaqGuiControl.this.disp));
                        }
                        DaqGuiControl.this.runMonitor.execute();
                    } else {
                        DaqGuiControl.this.toggleWatchBtn.setToolTipText(DaqApplication.AppIcon.LOG_START.getTooltipText());
                        if (bl2) {
                            DaqGuiControl.this.toggleWatchBtn.setText(DaqApplication.AppIcon.LOG_START.getTooltipText());
                        }
                        if (bl) {
                            DaqGuiControl.this.toggleWatchBtn.setImage(DaqApplication.AppIcon.LOG_START.getIcon(DaqGuiControl.this.disp));
                        }
                        DaqApplication.getApp().getLogger().info("Killing runMonitor process...");
                        DaqGuiControl.this.runMonitor.terminate();
                    }
                }
            });
        }
        return this.toggleWatchBtn;
    }

    private Button getFreezeScrollBtn(Composite composite) {
        if (this.freezeScrollBtn == null) {
            this.freezeScrollBtn = new Button(composite, 8);
            this.freezeScrollBtn.setText("Freeze scrolling");
            GridData gridData = new GridData(128);
            gridData.horizontalSpan = 4;
            this.freezeScrollBtn.setLayoutData((Object)gridData);
            this.freezeScrollBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (DaqGuiControl.this.freezeScrollBtn.getText() == "Freeze scrolling") {
                        DaqGuiControl.this.freezeOn = true;
                        DaqGuiControl.this.freezeScrollBtn.setText("Resume");
                    } else {
                        DaqGuiControl.this.freezeOn = false;
                        DaqGuiControl.this.freezeScrollBtn.setText("Freeze scrolling");
                    }
                }
            });
        }
        return this.freezeScrollBtn;
    }

    private Text getLogArea() {
        return this.textAr;
    }

    private Text getLogArea(Composite composite) {
        if (this.textAr == null) {
            this.textAr = new Text(composite, 522);
            this.textAr.setEditable(false);
            GridData gridData = new GridData(16);
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            this.textAr.setLayoutData((Object)gridData);
            this.textAr.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (selectionEvent.detail == 0 && DaqGuiControl.this.freezeOn && DaqGuiControl.this.lineCount > 0) {
                        DaqGuiControl.this.textAr.getVerticalBar().setSelection(DaqGuiControl.this.lineCount);
                    } else if (selectionEvent.detail == 0) {
                        DaqGuiControl.this.lineCount = DaqGuiControl.this.textAr.getVerticalBar().getSelection();
                    }
                }
            });
            FontData fontData = new FontData("Monospace", 9, 0);
            Font font = new Font((Device)this.disp, fontData);
            this.textAr.setForeground(new Color((Device)this.disp, 0, 0, 255));
            this.textAr.setFont(font);
        }
        this.runMonitor.registerListener(new DaqCmdListener(){

            @Override
            public void outputReceived(String string) {
                if (!DaqGuiControl.this.textAr.isDisposed()) {
                    DaqGuiControl.this.updateLogArea(string);
                }
            }
        });
        return this.textAr;
    }

    private Text getGuiMessageArea(Composite composite) {
        if (this.guiMsgAr == null) {
            this.guiMsgAr = new Text(composite, 522);
            this.guiMsgAr.setEditable(false);
            GridData gridData = new GridData(16);
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            this.guiMsgAr.setLayoutData((Object)gridData);
            FontData fontData = new FontData("Monospace", 9, 0);
            Font font = new Font((Device)this.disp, fontData);
            this.guiMsgAr.setForeground(new Color((Device)this.disp, 255, 0, 0));
            this.guiMsgAr.setFont(font);
            this.guiLogMonitor.registerListener(new DaqCmdListener(){

                @Override
                public void outputReceived(String string) {
                    if (!DaqGuiControl.this.guiMsgAr.isDisposed()) {
                        System.out.println(string);
                        DaqGuiControl.this.updateGuiMsgAr(string);
                    }
                }
            });
            this.guiLogMonitor.execute();
        }
        return this.guiMsgAr;
    }

    protected void updateGuiMsgAr(final String string) {
        this.disp.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DaqGuiControl.this.guiMsgAr != null) {
                    DaqGuiControl.this.guiMsgAr.append("\n" + string);
                }
            }
        });
    }

    private void updateLogArea(final String string) {
        this.disp.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!DaqGuiControl.this.textAr.isDisposed()) {
                    DaqGuiControl.this.getLogArea().append("\n" + string);
                }
            }
        });
    }

    private void makeMenus() {
        Menu menu = new Menu((Decorations)this.shell, 2);
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("&File");
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        menuItem.setMenu(menu2);
        MenuItem menuItem2 = new MenuItem(menu2, 8);
        menuItem2.setText("Open &Run Descriptions...");
        menuItem2.setImage(DaqApplication.AppIcon.OPEN_RUN_DESCS.getIcon(this.disp));
        menuItem2.addSelectionListener((SelectionListener)this.getListenerForRunDescs(this.shell));
        MenuItem menuItem3 = new MenuItem(menu2, 8);
        menuItem3.setText("E&xit");
        MenuItem menuItem4 = new MenuItem(menu, 64);
        menuItem4.setText("&Daq");
        Menu menu3 = new Menu((Decorations)this.shell, 4);
        menuItem4.setMenu(menu3);
        MenuItem menuItem5 = new MenuItem(menu, 64);
        menuItem5.setText("&Help");
        Menu menu4 = new Menu((Decorations)this.shell, 4);
        menuItem5.setMenu(menu4);
        MenuItem menuItem6 = new MenuItem(menu3, 8);
        menuItem6.setText(DaqApplication.AppIcon.DAQ_START.getTooltipText());
        menuItem6.setImage(DaqApplication.AppIcon.DAQ_START.getIcon(this.disp));
        MenuItem menuItem7 = new MenuItem(menu3, 8);
        menuItem7.setText(DaqApplication.AppIcon.DAQ_STOP.getTooltipText());
        menuItem7.setImage(DaqApplication.AppIcon.DAQ_STOP.getIcon(this.disp));
        MenuItem menuItem8 = new MenuItem(menu3, 8);
        menuItem8.setText(DaqApplication.AppIcon.DAQ_PANIC.getTooltipText());
        menuItem8.setImage(DaqApplication.AppIcon.DAQ_PANIC.getIcon(this.disp));
        MenuItem menuItem9 = new MenuItem(menu4, 8);
        menuItem9.setText("&About");
        menuItem9.setImage(DaqApplication.AppIcon.HELP.getIcon(this.disp));
        menuItem9.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MessageBox messageBox = new MessageBox(DaqGuiControl.this.shell, 34);
                messageBox.setText("About " + DaqGuiControl.this.app.getAppTitle());
                messageBox.setMessage(DaqGuiControl.this.app.getAppTitle() + "\n\n\tJamie Ballin, Imperial College London (2007)");
                messageBox.open();
            }
        });
        this.shell.setMenuBar(menu);
    }

    private SelectionAdapter getListenerForRunDescs(final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = new FileDialog(shell).open();
                if (string != null) {
                    DaqGuiControl.this.populateTypeTable(string);
                }
            }
        };
    }

    public static void main(String[] stringArray) {
        Object object;
        DaqApplication daqApplication = stringArray.length > 0 ? DaqApplication.getApp(stringArray[0]) : DaqApplication.getApp("");
        if (daqApplication.isPersistenceEnabled()) {
            object = new CandidateRun("mpsNoise", "mps", "mpsNoiseTest", "4");
            CandidateRun candidateRun = new CandidateRun("mpsAnalysis", "mps", "mpsAnalysisTest", "7");
            daqApplication.saveRun((CandidateRun)object);
            daqApplication.saveRun(candidateRun);
            daqApplication.listRuns();
        }
        object = new DaqGuiControl(daqApplication);
        while (!((DaqGuiControl)object).shell.isDisposed()) {
            if (((DaqGuiControl)object).disp.readAndDispatch()) continue;
            ((DaqGuiControl)object).disp.sleep();
        }
        if (((DaqGuiControl)object).runMonitor != null) {
            ((DaqGuiControl)object).runMonitor.terminate();
        }
        if (((DaqGuiControl)object).guiLogMonitor != null) {
            ((DaqGuiControl)object).guiLogMonitor.terminate();
        }
        ((DaqGuiControl)object).disp.dispose();
        daqApplication.closeApp();
        daqApplication.getLogger().log(Level.INFO, "DaqApplication finished.");
    }

    protected Button makeStopDaqBtn(Composite composite, boolean bl, boolean bl2) {
        Button button = new Button(composite, 0x1000008);
        if (bl) {
            button.setImage(DaqApplication.AppIcon.DAQ_STOP.getIcon(this.disp));
        }
        if (bl2) {
            button.setText(DaqApplication.AppIcon.DAQ_STOP.getTooltipText());
        }
        button.setToolTipText(DaqApplication.AppIcon.DAQ_STOP.getTooltipText());
        return button;
    }

    protected Button makePanicDaqBtn(Composite composite, boolean bl, boolean bl2) {
        Button button = new Button(composite, 0x1000008);
        if (bl) {
            button.setImage(DaqApplication.AppIcon.DAQ_PANIC.getIcon(this.disp));
        }
        if (bl2) {
            button.setText(DaqApplication.AppIcon.DAQ_PANIC.getTooltipText());
        }
        button.setToolTipText(DaqApplication.AppIcon.DAQ_PANIC.getTooltipText());
        return button;
    }

    protected Button makeEndConfigBtn(Composite composite, boolean bl) {
        final Button button = new Button(composite, 0x1000008);
        if (bl) {
            button.setImage(DaqApplication.AppIcon.CONFIG_END.getIcon(this.disp));
        } else {
            button.setText(DaqApplication.AppIcon.CONFIG_END.getTooltipText());
        }
        button.setToolTipText(DaqApplication.AppIcon.CONFIG_END.getTooltipText());
        GridData gridData = new GridData(128);
        button.setLayoutData((Object)gridData);
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DaqService.getDaqService().endConfig();
            }
        });
        DaqService.getDaqService().registerDaqStatusListener(new DaqStatusListener(){

            @Override
            public void newStatus(DaqService.DaqStatus daqStatus) {
                if (daqStatus == DaqService.DaqStatus.BUSY) {
                    button.setEnabled(true);
                } else {
                    button.setEnabled(false);
                }
            }
        });
        return button;
    }

    protected Button makeEndRunBtn(Composite composite, boolean bl) {
        final Button button = new Button(composite, 0x1000008);
        if (bl) {
            button.setImage(DaqApplication.AppIcon.RUN_STOP.getIcon(this.disp));
        } else {
            button.setText(DaqApplication.AppIcon.RUN_STOP.getTooltipText());
        }
        button.setToolTipText(DaqApplication.AppIcon.RUN_STOP.getTooltipText());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DaqService.getDaqService().endRun();
            }
        });
        button.setEnabled(false);
        DaqService.getDaqService().registerDaqStatusListener(new DaqStatusListener(){

            @Override
            public void newStatus(DaqService.DaqStatus daqStatus) {
                if (daqStatus == DaqService.DaqStatus.BUSY) {
                    button.setEnabled(true);
                } else {
                    button.setEnabled(false);
                }
            }
        });
        return button;
    }

    protected Button makeEndSeqBtn(Composite composite, boolean bl) {
        final Button button = new Button(composite, 0x1000008);
        GridData gridData = new GridData(256);
        button.setLayoutData((Object)gridData);
        if (bl) {
            button.setImage(DaqApplication.AppIcon.SEQ_END.getIcon(this.disp));
        } else {
            button.setText(DaqApplication.AppIcon.SEQ_END.getTooltipText());
        }
        button.setToolTipText(DaqApplication.AppIcon.SEQ_END.getTooltipText());
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DaqService.getDaqService().endSequence();
            }
        });
        DaqService.getDaqService().registerDaqStatusListener(new DaqStatusListener(){

            @Override
            public void newStatus(DaqService.DaqStatus daqStatus) {
                if (daqStatus == DaqService.DaqStatus.BUSY) {
                    button.setEnabled(true);
                } else {
                    button.setEnabled(false);
                }
            }
        });
        return button;
    }

    protected Button makeStartRunButton(Composite composite, boolean bl) {
        final Button button = new Button(composite, 0x1000008);
        if (bl) {
            button.setImage(DaqApplication.AppIcon.RUN_START.getIcon(this.disp));
        } else {
            button.setText(DaqApplication.AppIcon.RUN_START.getTooltipText());
        }
        button.setToolTipText(DaqApplication.AppIcon.RUN_START.getTooltipText());
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    if (DaqGuiControl.this.getCandidateRunEditor((Composite)DaqGuiControl.this.shell).getSelection() != null) {
                        CandidateRun candidateRun = (CandidateRun)DaqGuiControl.this.getCandidateRunEditor((Composite)DaqGuiControl.this.shell).getSelection().getData();
                        DaqService.getDaqService().startRun(candidateRun);
                    } else {
                        DaqService.getDaqService().startRun();
                    }
                }
                catch (DaqStatusException daqStatusException) {
                    MessageBox messageBox = new MessageBox(DaqGuiControl.this.shell, 33);
                    messageBox.setText("Run dispatch");
                    messageBox.setMessage("The Daq cannot execute the command. The error reported was: " + daqStatusException.getMessage());
                    messageBox.open();
                }
            }
        });
        DaqService.getDaqService().registerDaqStatusListener(new DaqStatusListener(){

            @Override
            public void newStatus(DaqService.DaqStatus daqStatus) {
                if (daqStatus != DaqService.DaqStatus.COMM_ERROR) {
                    button.setEnabled(true);
                }
            }
        });
        return button;
    }

    protected Button makeRefreshDaqStatusBtn(Composite composite, boolean bl) {
        Button button = new Button(composite, 0x1000008);
        GridData gridData = new GridData(256);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DaqService.getDaqService().refreshStatus();
            }
        });
        if (bl) {
            button.setImage(DaqApplication.AppIcon.DAQ_REFRESH.getIcon(this.disp));
        } else {
            button.setText(DaqApplication.AppIcon.DAQ_REFRESH.getTooltipText());
        }
        button.setToolTipText(DaqApplication.AppIcon.DAQ_REFRESH.getTooltipText());
        button.setEnabled(true);
        return button;
    }
}

