/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.imperial.ph.hep.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.classic.Session;
import uk.ac.imperial.ph.hep.datamodel.CandidateRun;
import uk.ac.imperial.ph.hep.service.DaqService;

public class DaqApplication {
    private static DaqApplication me = null;
    private static SessionFactory sessionFactory = null;
    private static Logger logger = null;
    private Properties props = null;
    private String propsFile = "DaqApplication.props";
    public static final String SHORT_TITLE = "maps.daq";

    public Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(SHORT_TITLE);
            logger.setLevel(Level.FINEST);
        }
        return logger;
    }

    public static DaqApplication getApp(String string) {
        if (me == null) {
            me = new DaqApplication(string);
        }
        return me;
    }

    public static DaqApplication getApp() {
        if (me == null) {
            throw new RuntimeException("DaqApplication has not been initialised!");
        }
        return me;
    }

    private DaqApplication(String string) {
        this.getLogger().info("Starting DaqApplication.");
        Properties properties = new Properties();
        if (string != "") {
            try {
                properties.load(new FileInputStream(new File(string)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.severe("DaqApplication properties file not found!");
            }
            catch (IOException iOException) {
                logger.severe("DaqApplication properties file loading failed!");
            }
            this.propsFile = string;
        }
        this.props = properties;
        Level level = Level.parse(properties.getProperty(PropKey.DEBUG_LEVEL.toString(), Level.FINEST.toString()));
        this.props.setProperty(PropKey.DEBUG_LEVEL.toString(), level.toString());
        String string2 = "guiLog.txt";
        if (string2 != "") {
            try {
                logger.info("Logger will send output to file: " + string2);
                FileHandler fileHandler = new FileHandler(string2);
                fileHandler.setFormatter(new SimpleFormatter());
                fileHandler.setLevel(level);
                logger.addHandler(fileHandler);
            }
            catch (IOException iOException) {
                logger.warning("Logger could not open specified log file, " + string2);
            }
        }
        if (this.isPersistenceEnabled()) {
            try {
                logger.info("Creating Hibernate Session Factory...");
                sessionFactory = new AnnotationConfiguration().configure().buildSessionFactory();
                logger.info("Created Hibernate Session Factory successfully");
            }
            catch (Throwable throwable) {
                logger.severe("Could not create Hibernate Session Factory! " + throwable.getMessage());
                System.err.println("Initial SessionFactory creation failed." + throwable);
                throw new ExceptionInInitializerError(throwable);
            }
        } else {
            logger.info("Not doing persistence!");
        }
        logger.info("Persistence property: " + System.getProperty("persistence"));
        logger.info("DaqApplication initialisation complete.");
    }

    public boolean isPersistenceEnabled() {
        return System.getProperty("persistence").equals("enabled");
    }

    public void closeApp() {
        logger.info("DaqApplication closing up shop.");
        DaqService.getDaqService().dispose();
        try {
            this.props.store(new FileOutputStream(this.propsFile), "DaqApplication Properties");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            logger.warning("Failed to write out properties file to " + this.propsFile);
        }
    }

    public String getAppTitle() {
        return "Calice Maps Daq Gui";
    }

    public String getGuiDir() {
        if (System.getProperty("application.home") != null) {
            return System.getProperty("application.home");
        }
        return "";
    }

    public SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public void saveRun(CandidateRun candidateRun) {
        Session session = this.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        session.save((Object)candidateRun);
        session.getTransaction().commit();
    }

    public void listRuns() {
        Session session = this.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        List list = session.createQuery("from CandidateRun").list();
        System.out.println(list.size() + " CandidateRuns have been persisted.");
        for (CandidateRun candidateRun : list) {
            System.out.println(candidateRun.toString());
        }
        session.getTransaction().commit();
    }

    private static enum PropKey {
        DEBUG_LEVEL("debug_level"),
        LOG_FILE("log_file");

        private final String key;

        public String toString() {
            return this.key;
        }

        private PropKey(String string2) {
            this.key = string2;
        }
    }

    public static enum AppIcon {
        DAQ_READY("icons/daq_ready.gif", "Daq System is ready."),
        DAQ_BUSY("icons/daq_busy.gif", "Daq System is busy."),
        DAQ_START("icons/daq_start.gif", "Start Daq"),
        DAQ_STOP("icons/daq_stop.gif", "Stop Daq"),
        DAQ_PANIC("icons/daq_panic.gif", "Panic Daq!"),
        DAQ_COMM_ERROR("icons/daq_comm_error.gif", "Daq System not contactable."),
        DAQ_REFRESH("icons/daq_refresh.gif", "Refresh Daq Status"),
        RUN_START("icons/run_start.gif", "Start run"),
        SEQ_END("icons/sequence_end.gif", "End sequence"),
        CONFIG_END("icons/config_end.gif", "End config"),
        RUN("icons/run.gif", ""),
        OPEN_RUN_DESCS("icons/open_run_descriptions.gif", "Open run descriptions..."),
        RUN_STOP("icons/run_stop.gif", "Stop run"),
        LOG_START("icons/log_start.gif", "Start logging"),
        LOG_STOP("icons/log_stop.gif", "Stop logging"),
        LOG_OPEN("icons/log_open.gif", "Open log file..."),
        HELP("icons/help_contents.gif", "Help");

        private final String location;
        private final String toolTip;

        private AppIcon(String string2, String string3) {
            this.location = DaqApplication.getApp().getGuiDir() + string2;
            this.toolTip = string3;
        }

        public Image getIcon(Display display) {
            return new Image((Device)display, this.location);
        }

        public String getTooltipText() {
            return this.toolTip;
        }
    }
}

