/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.imperial.ph.hep.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import uk.ac.imperial.ph.hep.command.DaqCmdListener;
import uk.ac.imperial.ph.hep.command.DaqCommand;
import uk.ac.imperial.ph.hep.command.impl.DaqStateChangeCmd;
import uk.ac.imperial.ph.hep.datamodel.CandidateRun;
import uk.ac.imperial.ph.hep.service.DaqApplication;
import uk.ac.imperial.ph.hep.service.DaqRunChangedListener;
import uk.ac.imperial.ph.hep.service.DaqStatusException;
import uk.ac.imperial.ph.hep.service.DaqStatusListener;

public class DaqService {
    private DaqStatus status = DaqStatus.COMM_ERROR;
    private List<DaqStatusListener> listeners = new ArrayList<DaqStatusListener>();
    private List<DaqRunChangedListener> otherListeners = new ArrayList<DaqRunChangedListener>();
    private Logger logger = DaqApplication.getApp().getLogger();
    private static DaqService moi;
    private Thread refresher;
    private int currentRunNumber;

    public String[] getRuntimeEnvironment() {
        String[] stringArray = new String[]{"CALICEMAPS1_DIR=/home/caliceon/sw/CALICEMAPS1/CALICEMAPS1", "PLATFORM=Linux", "LD_LIBRARY_PATH=:/opt/root-5.16/lib/root:/home/caliceon/sw/CALICEMAPS1/CALICEMAPS1/lib", "PATH=/home/caliceon/jdk1.6.0_03/bin:/usr/lib/qt-3.3/bin:/usr/kerberos/bin:/usr/lib/ccache:/usr/local/bin:/usr/bin:/bin:/opt/root-5.16/bin:/home/caliceon/bin:./bin:./online/bin:./daquser/bin:./records/bin:/home/caliceon/bin:./bin:./online/bin:./daquser/bin:./records/bin:/opt/root-5.16/bin:/home/caliceon/bin:./bin:./online/bin:./daquser/bin:./records/bin"};
        return stringArray;
    }

    public String getCmdPath() {
        return "/home/caliceon/online/bin/";
    }

    private DaqService() {
        this.logger.info("Constructing Daq Status monitor thread.");
        this.refresher = new Thread(){
            boolean keepGoing = true;

            @Override
            public void run() {
                try {
                    this.keepGoing = true;
                    while (this.keepGoing) {
                        Thread.sleep(3000L);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DaqService.this.refreshStatus();
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.keepGoing = false;
                }
            }

            @Override
            public void interrupt() {
                DaqService.this.logger.info("Closing Daq Status monitor thread.");
                this.keepGoing = false;
            }
        };
        this.refresher.start();
    }

    public static DaqService getDaqService() {
        if (moi == null) {
            moi = new DaqService();
        }
        return moi;
    }

    public void startRun(CandidateRun candidateRun) throws DaqStatusException {
        this.logger.info("Starting candidate run, " + candidateRun.getRunType());
        if (this.status == DaqStatus.COMM_ERROR) {
            this.logger.warning("startRun issued, but Daq is in a a COMM_ERROR status!");
            throw new DaqStatusException(this.status);
        }
        if (this.status == DaqStatus.BUSY) {
            this.logger.info("Daq status is busy, but I'll start a new run anyway...");
        }
        this.setStatus(DaqStatus.BUSY);
        candidateRun.getDaqCommand().registerListener(new DaqCmdListener(){

            @Override
            public void outputReceived(String string) {
                System.out.println("Daq Service - " + string);
            }
        });
        candidateRun.getDaqCommand().execute();
        this.logger.info("Executed startRun command successfully.");
    }

    public void startRun() throws DaqStatusException {
        this.logger.info("Starting slow readout run...");
        if (this.status == DaqStatus.COMM_ERROR) {
            this.logger.warning("startRun issued, but Daq is in a a COMM_ERROR status!");
            throw new DaqStatusException(this.status);
        }
        this.logger.info("Started slow readout run.");
    }

    public void endSequence() {
        this.logger.info("Ending sequence...");
        DaqStateChangeCmd daqStateChangeCmd = new DaqStateChangeCmd(DaqStateChangeCmd.StateChangeInducer.SEQ_END);
        ((DaqCommand)daqStateChangeCmd).execute();
        this.refreshStatus();
        this.logger.info("Ended sequence.");
    }

    public void endConfig() {
        this.logger.info("Ending config...");
        DaqStateChangeCmd daqStateChangeCmd = new DaqStateChangeCmd(DaqStateChangeCmd.StateChangeInducer.CONFIG_END);
        ((DaqCommand)daqStateChangeCmd).execute();
        this.refreshStatus();
        this.logger.info("Ended config.");
    }

    public void endRun() {
        this.logger.info("Attempting to stop current run...");
        DaqStateChangeCmd daqStateChangeCmd = new DaqStateChangeCmd(DaqStateChangeCmd.StateChangeInducer.RUN_END);
        ((DaqCommand)daqStateChangeCmd).execute();
        this.refreshStatus();
        this.logger.info("Ended run.");
    }

    public void panic() {
        this.logger.info("Panicking Daq...");
        DaqStateChangeCmd daqStateChangeCmd = new DaqStateChangeCmd(DaqStateChangeCmd.StateChangeInducer.PANIC);
        ((DaqCommand)daqStateChangeCmd).execute();
        this.refreshStatus();
        this.logger.info("Panic over.");
    }

    public void startup() {
        this.logger.info("Starting Daq...");
        DaqStateChangeCmd daqStateChangeCmd = new DaqStateChangeCmd(DaqStateChangeCmd.StateChangeInducer.START_UP);
        daqStateChangeCmd.registerListener(new DaqCmdListener(){

            @Override
            public void outputReceived(String string) {
                System.out.println(string);
            }
        });
        ((DaqCommand)daqStateChangeCmd).execute();
        this.refreshStatus();
        this.logger.info("Started Daq.");
    }

    public void shutdown() {
        this.logger.info("Shutting Daq down...");
        DaqStateChangeCmd daqStateChangeCmd = new DaqStateChangeCmd(DaqStateChangeCmd.StateChangeInducer.SHUT_DOWN);
        daqStateChangeCmd.registerListener(new DaqCmdListener(){

            @Override
            public void outputReceived(String string) {
                System.out.println(string);
            }
        });
        ((DaqCommand)daqStateChangeCmd).execute();
        this.refreshStatus();
        this.logger.info("Daq shutdown.");
    }

    public DaqStatus getStatus() {
        return this.status;
    }

    public void registerDaqStatusListener(DaqStatusListener daqStatusListener) {
        this.listeners.add(daqStatusListener);
    }

    public void removeDaqStatusListener(DaqStatusListener daqStatusListener) {
        this.listeners.remove(daqStatusListener);
    }

    public void registerDaqRunChangedListener(DaqRunChangedListener daqRunChangedListener) {
        this.otherListeners.add(daqRunChangedListener);
    }

    public void removeDaqRunChangedListener(DaqRunChangedListener daqRunChangedListener) {
        this.otherListeners.remove(daqRunChangedListener);
    }

    private void setStatus(DaqStatus daqStatus) {
        if (this.status != daqStatus) {
            this.status = daqStatus;
            this.logger.info("New Daq status being set: " + daqStatus.getInterpretation());
            for (DaqStatusListener daqStatusListener : this.listeners) {
                daqStatusListener.newStatus(daqStatus);
            }
        }
    }

    public DaqStatus refreshStatus() {
        if (!this.isDaqAlive()) {
            this.setStatus(DaqStatus.COMM_ERROR);
        } else if (this.isDaqBusy()) {
            this.setStatus(DaqStatus.BUSY);
        } else {
            this.setStatus(DaqStatus.READY);
        }
        this.currentRunNumber = this.getCurrentRun();
        for (DaqRunChangedListener daqRunChangedListener : this.otherListeners) {
            daqRunChangedListener.newRun(this.currentRunNumber);
        }
        return this.getStatus();
    }

    public void finalize() throws Throwable {
        this.refresher.interrupt();
    }

    public void dispose() {
        this.refresher.interrupt();
        moi = null;
    }

    private native int getCurrentRun();

    private boolean isDaqAlive() {
        try {
            Process process = Runtime.getRuntime().exec("pgrep -x runner");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            if (bufferedReader.readLine() == null || bufferedReader.readLine() == "") {
                return false;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.logger.warning("Couldn't find out status of runner: " + iOException.getMessage());
            return false;
        }
        return true;
    }

    private native boolean isDaqBusy();

    static {
        System.loadLibrary("DaqService");
        moi = null;
    }

    public static enum DaqStatus {
        BUSY("Daq is busy", DaqApplication.AppIcon.DAQ_BUSY),
        READY("Daq is ready", DaqApplication.AppIcon.DAQ_READY),
        COMM_ERROR("Daq is unavailable", DaqApplication.AppIcon.DAQ_COMM_ERROR);

        private String interpretation;
        private DaqApplication.AppIcon icon;

        private DaqStatus(String string2, DaqApplication.AppIcon appIcon) {
            this.interpretation = string2;
            this.icon = appIcon;
        }

        public String getInterpretation() {
            return this.interpretation;
        }

        public DaqApplication.AppIcon getAppIcon() {
            return this.icon;
        }
    }
}

