#include "DaqService.h"
#include <jni.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <iostream>

#include "runnerDefine.icc"

#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

#include "ShmObject.hh"
#include "RunMonitorShm.hh"
#include "UtlArguments.hh"

JNIEXPORT jint JNICALL Java_uk_ac_imperial_ph_hep_service_DaqService_getCurrentRun (JNIEnv* env, jobject jobj) {
	try {
		ShmObject<RunMonitorShm> shmRunMonitor(RunMonitorShm::shmKey);
		RunMonitorShm *q(shmRunMonitor.payload());
		if(q==0) {
			std::cout << "In DaqService::currentRun (JNI Call): ERK!" << std::endl;
			return 0;
		}
#ifndef DAQ_ILC_TIMING
		DaqRunStart *p(&(q->runStart()));
#else
		IlcRunStart *p(&(q->runStart()));
#endif
		if(p==0) {
			std::cout << "In DaqService::currentRun (JNI Call): ERK2!" << std::endl;
			return 0;
		}

		return p->runNumber();
	} catch ( ... ) {
		std::cout << "In DaqService::getCurrentRun (JNI Call): something's gone horribly wrong!" << std::endl;
	}
	
	return 0;
}

/*
 * Class:     uk_ac_imperial_ph_hep_service_DaqService
 * Method:    isDaqBusy
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_uk_ac_imperial_ph_hep_service_DaqService_isDaqBusy
(JNIEnv* env, jobject obj) {
	try {
		ShmObject<RunMonitorShm> shmRunMonitor(RunMonitorShm::shmKey);
		RunMonitorShm *q(shmRunMonitor.payload());
		if(q==0) {
			return false;
		}
#ifndef DAQ_ILC_TIMING
		DaqRunStart *p(&(q->runStart()));
#else
		IlcRunStart *p(&(q->runStart()));
#endif
		if(p == 0) {
			return false;
		}
		if(p->runType().type()==IlcRunType::slwMonitor) {
			return false;
		}

	} catch ( ... ) {
		std::cout << "In DaqService::isDaqBusy (JNI Call): something's gone horribly wrong!" << std::endl;
		return false;
	}
	return true;
}
