#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>

#include "UtlArguments.hh"
#include "UsbDaqDevice.hh"

using namespace std;

int main(int argc, const char **argv) {

  UtlArguments argh(argc,argv);
  const unsigned numberOfUsbDaqs(argh.lastArgument(5));
  if(argh.help()) return 0;

  std::vector<MpsUsbDaqRunData> v;

  for(unsigned i(0);i<numberOfUsbDaqs;i++) {
    UsbDaqDevice *p(new UsbDaqDevice);
    if(p->alive()) {

      MpsUsbDaqRunData x;
      assert(p->readMpsUsbDaqRunData(x));
      v.push_back(x);
    } else {
      i=numberOfUsbDaqs;
    }

    //delete p;
  }

  for(unsigned i(0);i<v.size();i++) {
    v[i].print(std::cout) << std::endl;
  }

  return 0;
}
