#include <iostream>
#include <sstream>
#include <fstream>

#include "UtlArguments.hh"
#include "MpsSensor1ConfigurationData.hh"

using namespace std;

int main(int argc, const char **argv) {
 
  UtlArguments argh(argc,argv);

  const unsigned sensorId(argh.optionArgument('s',99,"Sensor id"));
  const unsigned trim(argh.optionArgument('t',0,"Trim value"));

  const bool mask(argh.option('m',true,"Mask specified channels"));
  const unsigned x(argh.optionArgument('x',168,"X pixel to mask"));
  const unsigned y(argh.optionArgument('y',168,"Y pixel to mask"));
  const std::string file(argh.optionArgument('f',"pixel.txt","File name for list of pixels"));

  if(argh.help()) return 0;

  MpsSensor1ConfigurationData d;

  std::ostringstream sout;
  sout << "cfg/MpsSensor1ConfigurationDataSensor"
       << std::setw(2) << std::setfill('0') << sensorId << ".cfg";
  if(!d.readFile(sout.str())) {
    std::cout << "Sensor file " << sout.str() << " cannot be read" << std::endl;
    return 1;
  }

  bool modified(false);
  if(argh.option('t')) {
    d.trimSensor(trim);
    modified=true;
  }

  if(argh.option('x') && argh.option('y')) {
    d.mask(x,y,mask);
    modified=true;
  }

  if(argh.option('f')) {
    std::ifstream fin(file.c_str());
    if(!fin) {
      std::cout << "Pixel list file " << file << " cannot be read" << std::endl;
      return 2;
    }
    unsigned x,y;
    while(fin) {
      fin >> x >> y;
      if(fin) {
	d.mask(x,y,mask);
	modified=true;
      }
    }
    fin.close();
  }

  d.print();

  if(modified) {
    if(!d.writeFile(sout.str())) {
      std::cout << "Sensor file " << sout.str() << " cannot be written" << std::endl;
      return 3;
    }
  }

  return 0;
}
