#!/usr/bin/perl -w

#use strict;
use English;
use Tk;


#global variables

#Commands to start
my $path="/home/caliceon/online/";
my $RunTypes=$path."knownRunTypes.txt";
my $RunMonitor=$path."bin/runMonitor";
my $startUp=$path."daquser/bin/startUp";
my $shutDown=$path."bin/shutDown";
my $runStart=$path."bin/runStart";
my $runEnd=$path."bin/runEnd";


#Remote Communication

#trigger Socket
my $triggercomputer='flchcaldaq03';
my $trigger_start_command='/home/caliceon/online/fakecommand';
my $trigger_stop_command='/home/caliceon/online/fakecommand';

#Ecal socket
my $ecalcomputer='flchcaldaq03';
my $ecal_start_command='/home/caliceon/online/fakecommand';
my $ecal_stop_command='/home/caliceon/online/fakecommand';

#Hcal socket
my $hcalcomputer='flchcaldaq03';
my $hcal_start_command='/home/caliceon/online/fakecommand';
my $hcal_stop_command='/home/caliceon/online/fakecommand';

# the run command to start
my $CommandLine;

#the logfile to tail
my $LogFile;

#have we started up ?
my $IsRunning=0;

#control sequence
my $control_running="ps -au caliceon|grep runner";

#list of simple run, basic mode 
my @RunTypeSimple=("crcNoise","emcNoise","emcBeam","emcBeamHoldScan","ahcCmNoise",
		   "ahcPmNoise","ahcCmLedVcalibScan","ahcCmLedHoldScan","ahcPmLedVcalibScan",
		   "ahcPmLedHoldScan","ahcBeam","ahcBeamHoldScan","ahcBeamStageScan",
		   "beamData","beamStageScan","cosmicsData");

#currently displayed list
my @run=@RunTypeSimple;

#to kill clean
my $Pid_RunMonitor;
my $Pid_Tail;

# option field value
my $options;

#event field value
my $events_number;

#Write switch
my $Write;

#Expert mode switch
my $Expert;

#sockets status
my $trigger=0;
my $ecal=0;
my $hcal=0;


#
#Beginning of geometry drawing
#
#

#Main Window
my $Window=MainWindow->new(-height=>600,-width=>600);

#Window Geometry Disposition
my $LeftFrame=$Window->Frame(-relief=>"raised")->pack(-side=>"left",-expand=>1,-fill=>"both");
my $RightFrame=$Window->Frame(-relief=>"raised")->pack(-side=>"right",-expand=>1,-fill=>"both");

#Content of left Frame from top top bottom
my $SocketFrame=$LeftFrame->Frame(-relief=>"raised")->pack(-side=>"top",-fill=>"x");
my $StartFrame=$LeftFrame->Frame(-relief=>"raised")->pack(-side=>"top",-fill=>"x");
my $RunFrame=$LeftFrame->Frame(-relief=>"ridge")->pack(-side=>"top",-expand=>1,-fill=>"both");
my $ShutDownFrame=$LeftFrame->Frame(-relief=>"raised")->pack(-side=>"bottom",-fill=>"x");

#sockets Frame, 3 buttons
my $HcalUpButton=$SocketFrame->Button(-text=>"Open Hcal\nsocket",-command=>sub{hcal_socket()})->pack(-side=>"right",-fill=>'x');
my $EcalButton=$SocketFrame->Button(-text=>"Open Ecal\nsocket",-command=>sub{ecal_socket()})->pack(-side=>"left",-fill=>'x');
my $TriggerButton=$SocketFrame->Button(-text=>"Open Trigger\nsocket",-command=>sub{trigger_socket()})->pack(-side=>"top",-fill=>'x');


#StartUp Frame, 1 button && 1 text
my $StartUpButton=$StartFrame->Button(-text=>"DAQ StartUp",-command=>sub{startup_prepare()})->pack(-side=>"left");
my $StartUpText=$StartFrame->Label(-text=>"Load SiPM bias Settings.\nLow Voltage MUST be on.")->pack(-side=>"right");


#Shutdown Frame, 1 button && 1status text
my $ShutDownButton=$ShutDownFrame->Button(-text=>"DAQ ShutDown",-command=>sub{shutdown_prepare()})->pack(-side=>"left");
my $ShutDownText=$ShutDownFrame->Label(-text=>"DAQ is not running",
					-background=>'grey',
					-foreground=>"black")
				->pack(-side=>"right");


#RunControl Frame

#Header
my $RunIntro=$RunFrame->Label(-text=>"---\tRun Control\t---")->pack();

#RunType List
#list of possible runs with scroll bar
my $ListFrame=$RunFrame->Frame()->pack(-fill=>"both",-expand=>1);
my $RunTypeList=$ListFrame->Listbox(-selectmode=>"browse")->pack(-side=>"left",-fill=>"both",-expand=>1);
my $Scroll=$ListFrame->Scrollbar(-orient=>"v",-command=>[yview=>$RunTypeList]);
$RunTypeList->configure(-yscrollcommand=>['set',$Scroll]);
$Scroll->pack(-side=>"right",-fill=>"y",-expand=>1);


#
#prepare first Run list
#

foreach $type (@RunTypeSimple) {
	$RunTypeList->insert('end',$type);
}

my $ExpertMode=$RunFrame->Checkbutton(-text=>"Expert mode RunType List",
				      	-variable=>\$Expert,
					-command=>\&change_run_list)
			->pack();

#Write Enable button
my $WriteEnable=$RunFrame->Checkbutton(-text=>"Save data",-variable=>\$Write)->pack();
$WriteEnable->select();

#
#Run Options
#
my $OptionFrame=$RunFrame->Frame()->pack(-fill=>"x");

#Events number Field
my $EventsText=$OptionFrame->Label(-text=>"Number of Events (-e)")->pack(-side=>"left");
my $EventsField=$OptionFrame->Entry(-width=>6)->pack(-side=>"left");

#Option field
my $OptionField=$OptionFrame->Entry(-width=>3)->pack(-side=>"right");
my $OptionText=$OptionFrame->Label(-text=>"Options (-v)")->pack(-side=>"right");


#Reload DAQ settings button
my $ResetButton=$RunFrame->Button(-text=>"RELOAD HCAL DAQ SETTINGS",
				  -command=>sub{reload()},
				  -foreground=>"red")->pack();
#
# Start/Stop Run
#
my $ButtonFrame=$RunFrame->Frame()->pack(-side=>"bottom",-expand=>1,-fill=>"x");
my $StartRunButton=$RunFrame->Button(-text=>"Start Run",-command=>sub{run_start()})->pack(-side=>"left");
my $StopRunButton=$RunFrame->Button(-text=>"Stop Run",-command=>sub{run_stop()})->pack(-side=>"right");
my $runstarted=$RunFrame->Label(-text=>"No run at the moment\n")->pack(-side=>"bottom",-fill=>"x");

#
#RightFrame


#RunMonitor check

my $CheckFrame=$RightFrame->Frame()->pack(-expand=>1,-fill=>"both");
my $t;

#Log Frame

my $LogFrame=$RightFrame->Frame()->pack(-side=>"bottom",-expand=>1,-fill=>"both");
my $t2;

#
#Update RunMonitor

$Pid_RunMonitor=open(H2, "$RunMonitor|") or die "Nope: $OS_ERROR";
$t2 = $CheckFrame->Text(-width => 80, -height => 46, -wrap => 'none',-background=>"white");
$t2->pack(-expand => 1);
$CheckFrame->fileevent(H2, 'readable', [\&fill_check_widget, $t2]);


MainLoop;

open(EXIT, "kill $Pid_RunMonitor |") or die "Nope: $OS_ERROR";
if(defined($Pid_Tail)){
	open(EXIT, "kill $Pid_Tail|") or die "Nope: $OS_ERROR";
}
close(EXIT);
close(TRIGGER);
close(ECAL);
close(HCAL);
close(H);
close(H2);
close(RUNTYPES);
close(STARTUP);
close(SHUTDOWN);
close(STARTRUN);
close(STOPRUN);
close(CONTROL);

#
#
#Subroutines
#button press
#
#




#StartUp button behaviour

sub startup_prepare{

	if(!$IsRunning){
		open(STARTUP, "$startUp|") or die "Nope: $OS_ERROR";
		do{
			$line1=<STARTUP>;	
			print $line1;
		}
		while($line1 !~ m=data/log/Log(\d+).out=);
		
		$LogFile=$path.$&;
		print $LogFile,"\t".$&;
		$ShutDownText->configure(-text=>"DAQ IS running",-background=>"green",-foreground=>"black");
	
		$Pid_Tail=open(H, "tail -f $LogFile|") or die "Nope: $OS_ERROR";
		$t = $LogFrame->Text(-width => 80, -height => 25, -wrap => 'none',-background=>'white');
		$t->pack(-expand => 1);
		$LogFrame->fileevent(H, 'readable', [\&fill_log_widget, $t]);
		$IsRunning=1;
	}
	
	
}

#Shutdown button behaviour
sub shutdown_prepare{
	if($IsRunning){
		$ShutDownText->configure(-text=>"DAQ is shutting down",-background=>"yellow",-foreground=>"black");
		open(SHUTDOWN, "$shutDown|") or die "Nope: $OS_ERROR";
		$line1=<SHUTDOWN>;
		sleep(5);

		open(CONTROL, "$control_running|") or die "Nope: $OS_ERROR";
		$line1=<CONTROL>;
		if(!defined($line1) or $line1!~m/runner/){
			open(EXIT, "kill $Pid_Tail|") or die "Nope: $OS_ERROR";
			$Pid_Tail=undef;
			$ShutDownText->configure(-text=>"DAQ is not running",
						 -background=>"grey",
						 -foreground=>"black");
			$IsRunning=0;
			return;
		}
		$ShutDownText->configure(-text=>"DAQ is STILL  running",
						 -background=>"red",
						 -foreground=>"white");
	}
}

#Expert mode switch behaviour
sub change_run_list{
	$RunTypeList->delete(0,'end');
	@run=();
	if($Expert){
		open(RUNTYPES, "<$RunTypes") or die "Nope: $OS_ERROR";
		while(defined($line1=<RUNTYPES>)){
			$line1=~ m/\s+Type\s+=\s+\d+\s+=\s+(\w+),/;
			$RunTypeList->insert('end',$1);
			push @run,$1;
		}
	}
	else{
		foreach $type (@RunTypeSimple){
			$RunTypeList->insert('end',$type);
		}
		@run=@RunTypeSimple;
	}

}


#RunStart button behaviour
sub run_start{

	if(!$IsRunning){
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
	}else{
		$CommandLine=$runStart." ";
		if(!$Write){
			$CommandLine=$CommandLine."-w ";
		}
		if($options=$OptionField->get()){
			$CommandLine=$CommandLine."-v $options ";
		}
		if($events_number=$EventsField->get()){
			$CommandLine=$CommandLine."-e $events_number ";
		}
		my ($runtype)=$RunTypeList->curselection();
		if(!defined($runtype)){
			return;
		}
		$CommandLine=$CommandLine."-t $run[$runtype] ";
		open(STARTRUN, "$CommandLine|") or die "Nope: $OS_ERROR";
		$runstarted->configure(-text=>"The following run has started\n$CommandLine",-background=>'green');
	}

}

#RunStop button behaviour
sub run_stop{
	if(!$IsRunning){
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
	}else{
		open(STOPRUN, "$runEnd|") or die "Nope: $OS_ERROR";
		close(STOPRUN);
		$runstarted->configure(-text=>"No run at the moment\n",-background=>'grey');
	}
}

#Reload settings button behaviour
sub reload{
	if(!$IsRunning){
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
	}else{
		open(RUNTYPES, "$runStart -t ahcDacScan") or die "Nope: $OS_ERROR";
	}
}




#Open Trigger socket  button


sub trigger_socket {
	if(!$trigger){
		$TriggerButton->configure(-text=>"Close Trigger\nsocket");
		$trigger=1;
		open(TRIGGER,"ssh ".$triggercomputer." -t ".$trigger_start_command) or die "Nope: $OS_ERROR";
	}else {
		$TriggerButton->configure(-text=>"Open Trigger\nsocket");
		open(TRIGGER,"ssh ".$triggercomputer." -t ".$trigger_stop_command) or die "Nope: $OS_ERROR";
		$trigger=0;
	}
}

#Open ECAL socket  button
sub ecal_socket {
	if(!$ecal){
		$EcalButton->configure(-text=>"Close Ecal\nsocket");
		open(ECAL,"ssh ".$ecalcomputer." -t ".$ecal_start_command) or die "Nope: $OS_ERROR";
		$ecal=1;
	}else {
		$EcalButton->configure(-text=>"Open Ecal\nsocket");
		open(ECAL,"ssh ".$ecalcomputer." -t ".$ecal_stop_command) or die "Nope: $OS_ERROR";
		$ecal=0;
	}

}


#Open HCAL socket  button
sub hcal_socket {
	if(!$hcal){
		$HcalButton->configure(-text=>"Close Hcal\nsocket");
		open(HCAL,"ssh ".$hcalcomputer." -t ".$hcal_start_command) or die "Nope: $OS_ERROR";
		$hcal=1;
	}else {
		$HcalButton->configure(-text=>"Open Hcal\nsocket");
		open(HCAL,"ssh ".$hcalcomputer." -t ".$hcal_stop_command) or die "Nope: $OS_ERROR";
		$hcal=0;
	}

}


#Update log tail frame
sub fill_log_widget {

    my($widget) = @ARG;

    $ARG = <H>;
    $widget->insert('end', $ARG);
    $widget->yview('end');
} # end fill_text_widget 



#Update RunMonitor frame
sub fill_check_widget {

    my($widget) = @ARG;

    $ARG = <H2>;
    $widget->insert('end', $ARG);
    $widget->yview('end');
} # end fill_text_widget 
