#ifndef AhcSlowReadout_HH
#define AhcSlowReadout_HH

#include <iostream>
#include <fstream>

// dual/inc/utl
#include "UtlPack.hh"

// dual/inc/rcd
#include "RcdUserRW.hh"
#include "RcdHeader.hh"

// dual/inc/sub
#include "SubInserter.hh"
#include "SubAccessor.hh"
#include "DaqConfigurationStart.hh"
#include "AhcSlowRunData.hh"
#include "AhcSlowConfigurationData.hh"
//#include "AhcSlowControlData.hh"
#include "AhcSlowReadoutData.hh"

// dual/inc/skt
#include "DuplexSocket.hh"


class AhcSlowReadout : public RcdUserRW {

public:
  //  AhcSlowReadout(std::string ipAddress="localhost",
  AhcSlowReadout(std::string ipAddress="131.169.184.160", // tent
  //AhcSlowReadout(std::string ipAddress="131.169.184.162", // beam
		  unsigned port=1201, unsigned tries=10) :
    RcdUserRW(), _socket(ipAddress.c_str(),port,tries) {

    std::cout << std::endl << "SOCKET ESTABLISHED" << std::endl << std::endl;
  }

  virtual ~AhcSlowReadout() {
  }

  bool record(RcdRecord &r) {

    // Check record type
    if(r.recordType()==RcdHeader::startUp) {
      if(_printLevel>0) {
	std::cout << std::endl << "AhcSlowReadout::record()" << std::endl;
	r.RcdHeader::print(std::cout," ");
      }

      std::string recv;
      sendAndRecv("reset",recv);

      // Nothing to read back
    }

    if(r.recordType()==RcdHeader::runStart) {
      if(_printLevel>0) {
	std::cout << std::endl << "AhcSlowReadout::record()" << std::endl;
	r.RcdHeader::print(std::cout," ");
      }

      std::string recv;
      sendAndRecv("run",recv);

      SubInserter inserter(r);
      AhcSlowRunData *d(inserter.insert<AhcSlowRunData>(true));
      assert(d->parse(recv));
      if(_printLevel>0) d->print(std::cout," ");
    }

    /*
    // if(r.recordType()==RcdHeader::slowControl) {
    if(r.recordType()==RcdHeader::slowConfiguration) {
      if(_printLevel>2) {
	std::cout << std::endl << "AhcSlowReadout::record()" << std::endl;
	r.RcdHeader::print(std::cout," ");
      }

      std::string recv;
      sendAndRecv("control",recv);

      SubInserter inserter(r);
      //AhcSlowControlData *d(inserter.insert<AhcSlowControlData>(true));
      AhcSlowConfigurationData *d(inserter.insert<AhcSlowConfigurationData>(true));
      assert(d->parse(recv));
      if(_printLevel>2) d->print(std::cout," ");
    }
    */

    if(r.recordType()==RcdHeader::slowReadout) {
      if(_printLevel>4) {
	std::cout << std::endl << "AhcSlowReadout::record()" << std::endl;
	r.RcdHeader::print(std::cout," ");
      }

      std::string recv;
      sendAndRecv("readout",recv);

      SubInserter inserter(r);
      AhcSlowReadoutData *d(inserter.insert<AhcSlowReadoutData>(true));

      assert(d->parse(recv));
      //inserter.extend(d->numberOfModules()*sizeof(AhcSlowReadoutModuleData));
      inserter.extend(d->numberOfModules()*sizeof(AhcModuleSlowReadoutData));
      if(_printLevel>4) d->print(std::cout," ");
    }

    if(r.recordType()==RcdHeader::configurationStart) {
      if(_printLevel>2) {
	std::cout << std::endl << "AhcSlowReadout::record()" << std::endl;
	r.RcdHeader::print(std::cout," ");
      }

      SubAccessor accessor(r);
      //std::vector<const AhcSlowControlData*>
      //v(accessor.access<AhcSlowControlData>());
      std::vector<const AhcSlowConfigurationData*>
	v(accessor.access<AhcSlowConfigurationData>());
      assert(v.size()<=1);

      // Check for data to write down to PC
      if(v.size()==1 && v[0]->timeStamp()==0) {
	if(_printLevel>4) v[0]->print(std::cout," ");

	int x(v[0]->xPosition());
	int y(v[0]->yPosition());
	
	std::ostringstream sout;
	sout << "position " << x << " " << y;
	
	std::string recv;
	sendAndRecv(sout.str(),recv);
	
	SubInserter inserter(r);
	//	AhcSlowControlData *d(inserter.insert<AhcSlowControlData>(true));
	AhcSlowConfigurationData *d(inserter.insert<AhcSlowConfigurationData>(true));
	assert(d->parse(recv));
	if(_printLevel>4) d->print(std::cout," ");
      }
    }

    return true;
  }

  bool sendAndRecv(const std::string &s, std::string &r) {
    r.clear();

    if(_printLevel>6) std::cout << " sendAndRecv()  std::string to send "
				<< s.size()
				<< " bytes ==>" << s << "<==" << std::endl;

    std::string t("daqrequest "+s+'#');
    std::cout << t << std::endl;
    if(!_socket.send(t.c_str(),t.size())) {
      std::cerr << "AhcSlowReadout::sendAndRecv()  Error writing to socket;"
		<< " number of bytes written < " << s.size() << std::endl;
      perror(0);
      return false;
    }
    
    bool terminated(false);
    //bool terminated(true);
    char x;
    std::string h;
    std::cout <<"Before receving part! " << terminated << std::endl;
     
    for(unsigned i(0);!terminated;i++) {
      int n(-1);
      if(_printLevel>8) std::cout << " sendAndRecv()  Waiting for byte " << i;
      n=_socket.recv(&x,1);
      if(_printLevel>8) std::cout << "...got byte " << i << std::endl;
      
      if(n!=1) {
	std::cerr << "AhcSlowReadout::sendAndRecv()  Error reading from socket;"
		  << " number of bytes written = " << n << " < 1" << std::endl;
	perror(0);
	return false;
      }

      if(x=='#') terminated=true;
      else {
	if(i>10) r+=x;
	else     h+=x;
      }
    }

    if(_printLevel>6) std::cout << " sendAndRecv()  std::string recv ed "
				<< " header " << h.size()
				<< " bytes ==>" << h << "<=="
				<< ", message " << r.size()
				<< " bytes ==>" << r << "<==" << std::endl;

    return true;
  }
    
private:
  DuplexSocket _socket;
};

#endif
