#ifndef AhcVfeSlowControlsFile_HH
#define AhcVfeSlowControlsFile_HH

#include <string>
#include <fstream>
#include <iostream>

#include "UtlPack.hh"
#include "UtlPrintHex.hh"

#include "AhcVfeSlowControlsData.hh"


class AhcVfeSlowControlsFile {

public:
  AhcVfeSlowControlsFile() {
  }

  bool read(const std::string &file, AhcVfeSlowControlsData &a, unsigned readFE) {
    ifstream fin(file.c_str());
    if(!fin) 
      {
	std::cout << "error opening " << file << std::endl;
	return false;
      }
    
    bool dataStart(false);
    std::string strBuffer;
    char charBuffer[512];
    unsigned n(0),slot,fe,hab,d,value;
    
    while(fin.good()) {
      if (!dataStart)
	{
	  fin >> strBuffer;
	  if (strBuffer[0] == '#')
	    {
	      fin.getline(charBuffer,sizeof(charBuffer));
	    }
	  if (strBuffer=="--data--" || strBuffer=="--data-V2--") dataStart = true;
	}
      else
	{

	  if (strBuffer=="--data--") 
	    {
	      fin >> slot >> fe >> hab >> d >> value;
	      if(fin && fe == readFE) {
		n++;
		a.dac(hab,d,value);
	      }
	    }
	  else if (strBuffer=="--data-V2--") 
	    {
	      fin >> hab >> d >> value;
	      if (fin)
		{
		  n++;
		  a.dac(hab,d,value);
		}
	    }
	}
    }
    
    fin.close();
    std::cout << "read " << n << " DAC values for FE=" << readFE << " from "<< file << std::endl; 
    return n==12*18;
  }
  
  bool write(const std::string &file) {
    return true;
  }

  std::ostream& print(std::ostream &o, std::string s="") const {
    return o;
  }
  

private:
};

#endif
