#include <sstream>


void HstAhcHoldMulti()
{

  const unsigned scanwidth = 1110;
  const int MAXCHANNELS = 216;
  const char inputFileName[255] = "holdscanFE0.dat";    //which FE ?
  const char outputFileName[255] = "holdfit.dat";
  const char title[255] = "multi channel holdscan";
  const char psFileName[255] = "holdMulti.ps";
  
  ifstream in;
  in.open(inputFileName);

  ofstream out;
  out.open(outputFileName,ofstream::app);

  char buffer[5000];
  in.getline(buffer,sizeof(buffer));
  
  
  Double_t x[scanwidth],y[MAXCHANNELS][scanwidth],yErr[MAXCHANNELS][scanwidth],dummy;
  
  int i = 0;
  Double_t miny = 1e6;
  Double_t maxy = -1e6;
  Double_t hold[MAXCHANNELS],holdm[MAXCHANNELS],mean[MAXCHANNELS];
  
  for (int n = 0; n<MAXCHANNELS; n++) 
    {
      holdm[n] = -1e6;
      mean[n]=0;
    }
  
  while (in.good())  
    {
      in.getline(buffer,sizeof(buffer));
      istrstream *instr = new istrstream(buffer);
      *instr >> x[i];
      int j=0;
      while (j < MAXCHANNELS)
	{
	  *instr >> y[j][i] >> yErr[j][i];
	  if (y[j][i] < miny) miny = y[j][i];
	  if (y[j][i] > maxy) maxy = y[j][i];
	  if (holdm[j] < y[j][i]) {holdm[j] = y[j][i];hold[j]=x[i];}
	  mean[j] += y[j][i];
 	  j++;
	}
   
      i++;
      //      cout << buffer << endl;
    }
  in.close();
  cout << j << endl;

  for (int n = 0; n<j; n++) mean[n] /= i;
  
  for (int k(0);k<i;k++) x[k] *= 6.25;
  
  gStyle->SetTitleYOffset(1.4);
  
  TCanvas *c = new TCanvas("holdscanMulti","Holdscan");
    c->Divide(4,3);
  TGraph* gr[MAXCHANNELS];
  for (int chan=0;chan < MAXCHANNELS; chan++)
    {
      char graphTitle[512];
      sprintf(graphTitle,"holdscan chip %d chan %d", chan/18, chan%18);
      c->cd(chan/18+1);
      gr[chan] = new TGraph(i-1,x,y[chan]);
      gr[chan]->SetLineColor(chan%9+1);
      gr[chan]->SetMarkerStyle(21);
      gr[chan]->SetMarkerSize(0);
      gr[chan]->SetTitle(graphTitle);
      gr[chan]->SetMinimum(miny-0.1*(maxy-miny));
      gr[chan]->SetMaximum(maxy+0.1*(maxy-miny));
      gr[chan]->GetXaxis()->SetTitle("hold (ns)");
      gr[chan]->GetYaxis()->SetTitle("mean (channels)");
      gr[chan]->GetXaxis()->SetRangeUser(2500,2800);
      if (chan%18 == 0) gr[chan]->Draw("ALP");
      else gr[chan]->Draw("sameLP");
      cout << chan/18 << " " << chan%18 << " " << hold[chan] << endl;
    }
  
  for (int chip=0;chip < MAXCHANNELS/18;chip++)
    {
      cout << "chip " << chip << ": mean ";
      Double_t average = 0;
      Double_t minhold = 1e6;
      Double_t maxhold = 0;
      int holds=0;
      for (int chan=0;chan < 18 && chan < (MAXCHANNELS-18*chip);chan++)
	{
	  if (holdm[chip*18+chan]/mean[chip*18+chan] > 1.5)
	    {
	      if (hold[chip*18+chan] < minhold) minhold = hold[chip*18+chan];
	      if (hold[chip*18+chan] > maxhold) maxhold = hold[chip*18+chan];
	      average += hold[chip*18+chan];
	      holds++;
	    }
	}
      if (holds >0) average /= holds;
      cout << average << " min "<<minhold<<" max "<< maxhold<< " found "<<holds<<" holdtimes"<< endl;
    }

  Double_t pedestal[MAXCHANNELS];
  Double_t fithold[MAXCHANNELS];
  Double_t amplitude[MAXCHANNELS];
  Double_t minAmplitude = 1e6;
  Double_t maxAmplitude = -1e6;
  Double_t minHold = 1e6;
  

  for (int chip=0;chip < MAXCHANNELS/18;chip++)
    {
      cout << endl << "fitting:" << endl;
      TF1* fit[MAXCHANNELS];
      for (int chan=0;chan < MAXCHANNELS;chan++)
	{
	  if (holdm[chan]/mean[chan] > 1.5)
	    {
	      pedestal[chan] = (y[chan][0] + y[chan][1] + y[chan][2])/3.0;
	      fit[chan] = new TF1("hold","gaus",(hold[chan]-3)*6.25,(hold[chan]+3)*6.25);
	      gr[chan]->Fit(fit[chan],"QRN");
	      fit[chan] = new TF1("hold","gaus",fit[chan]->GetParameter(1)-3*6.26,fit[chan]->GetParameter(1)+3*6.25);
	      fit[chan]->SetLineColor(15);
	      fit[chan]->SetLineWidth(2);
	      gr[chan]->Fit(fit[chan],"QR+");

	      fithold[chan] = fit[chan]->GetParameter(1);
	      amplitude[chan] = fit[chan]->GetParameter(0) - pedestal[chan];
	      if (minAmplitude > amplitude[chan]) minAmplitude = amplitude[chan];
	      if (maxAmplitude < amplitude[chan]) maxAmplitude = amplitude[chan];
	      if (minHold > fithold[chan]) minHold = fithold[chan];
	      cout << "chip: " << chan/18 << " chan: " << chan%18 << " mean: " << fit[chan]->GetParameter(1) << " RMS: " << fit[chan]->GetParameter(2) << endl;
	    }
	}      
      
    }

  int writeOut = 0;  
  for (int chan=0;chan < MAXCHANNELS;chan++)
    {
      if (holdm[chan]/mean[chan] > 1.5)
	{
	  cout << "chip: " << chan/18 << " chan: " << chan%18 << " found hold: "<< fithold[chan]/6.25<< " shift from min: " << fithold[chan]-minHold << " relativ amplitude to min " << amplitude[chan]/minAmplitude << endl;
	  out << chan/18 << " " << chan%18 << " " << fithold[chan]-minHold << " "<< maxAmplitude<< " "<< minAmplitude<<" " << amplitude[chan] << endl;
	      writeOut++;
	}
    }
  
  cout << writeOut << " alive channels found"<<endl;
  out.close();

}
