#ifndef RcdCount_HH
#define RcdCount_HH

#include <string>
#include <iomanip>
#include <iostream>

#include "RcdHeader.hh"
#include "RcdRecord.hh"


class RcdCount {

public:
  RcdCount() {
    reset();
  }

  void reset() {
    _totalCount=0;
    for(unsigned i(0);i<=RcdHeader::endOfRecordTypeEnum;i++) _count[i]=0;
  }

  unsigned count(RcdHeader::RecordType rt) const {
    if(rt<RcdHeader::endOfRecordTypeEnum) return _count[rt];
    return 0;
  }

  unsigned totalCount() const {
    return _totalCount;
  }

  void operator+=(RcdHeader::RecordType rt) {
    _totalCount++;
    if(rt<RcdHeader::endOfRecordTypeEnum) _count[rt]++;
    else _count[RcdHeader::endOfRecordTypeEnum]++;
  }

  void operator+=(const RcdRecord &r) {
    operator+=(r.recordType());
  }

  std::ostream& print(std::ostream& o, std::string s="") const {
    o << s << "RcdCount::print()  Total number of records = " 
      << std::setw(10) << _totalCount << std::endl;

    for(unsigned i(0);i<RcdHeader::endOfRecordTypeEnum;i++) {
      if(_count[i]>0) {
	o << s << " Number of records of type " << std::setw(2) << i << " = " 
	  << RcdHeader::recordTypeName((RcdHeader::RecordType)i) << " = "
	  << std::setw(10) << _count[i] << std::endl;
      }
    }

    if(_count[RcdHeader::endOfRecordTypeEnum]>0)
      o << s << " Number of records of unknown type                 = " 
	<< std::setw(10) << _count[RcdHeader::endOfRecordTypeEnum]
	<< std::endl;

    return o;
  }


private:
  unsigned _totalCount;
  unsigned _count[RcdHeader::endOfRecordTypeEnum+1];
};

#endif
