#ifndef RcdUserBase_HH
#define RcdUserBase_HH

#include <iostream>
#include <fstream>

// dual/inc/rcd
#include "RcdRecord.hh"


class RcdUserBase {

public:
  RcdUserBase() : _printLevel(0) {
  }

  RcdUserBase(unsigned p) : _printLevel(p) {
  }

  virtual ~RcdUserBase() {
  }

  void printLevel(unsigned p) {
    _printLevel=p;
  }

  bool doPrint(RcdHeader::RecordType t, unsigned inc=0) {
    if(_printLevel==0) return false;
 
    switch (t) {
    case RcdHeader::startUp:            return _printLevel>( 0+inc);
    case RcdHeader::shutDown:           return _printLevel>( 0+inc);
    case RcdHeader::runStart:           return _printLevel>( 3+inc);
    case RcdHeader::runEnd:             return _printLevel>( 3+inc);
    case RcdHeader::configurationStart: return _printLevel>( 6+inc);
    case RcdHeader::configurationEnd:   return _printLevel>( 6+inc);
    case RcdHeader::slowReadout:        return _printLevel>( 9+inc);
    case RcdHeader::acquisitionStart:   return _printLevel>( 9+inc);
    case RcdHeader::acquisitionEnd:     return _printLevel>( 9+inc);
    case RcdHeader::spillStart:         return _printLevel>(12+inc);
    case RcdHeader::spillEnd:           return _printLevel>(12+inc);
    case RcdHeader::spill:              return _printLevel>(12+inc);
    case RcdHeader::transferStart:      return _printLevel>(12+inc);
    case RcdHeader::transferEnd:        return _printLevel>(12+inc);
    case RcdHeader::transfer:           return _printLevel>(12+inc);
    case RcdHeader::trigger:            return _printLevel>(15+inc);
    case RcdHeader::event:              return _printLevel>(15+inc);
      
    default: return false;
    };
  }

  void setPrint(RcdHeader::RecordType t) {

    switch (t) {
    case RcdHeader::startUp:            _printLevel= 3;
    case RcdHeader::shutDown:           _printLevel= 3;
    case RcdHeader::runStart:           _printLevel= 6;
    case RcdHeader::runEnd:             _printLevel= 6;
    case RcdHeader::configurationStart: _printLevel= 9;
    case RcdHeader::configurationEnd:   _printLevel= 9;
    case RcdHeader::slowReadout:        _printLevel=12;
    case RcdHeader::acquisitionStart:   _printLevel=12;
    case RcdHeader::acquisitionEnd:     _printLevel=12;
    case RcdHeader::spillStart:         _printLevel=15;
    case RcdHeader::spillEnd:           _printLevel=15;
    case RcdHeader::spill:              _printLevel=15;
    case RcdHeader::transferStart:      _printLevel=15;
    case RcdHeader::transferEnd:        _printLevel=15;
    case RcdHeader::transfer:           _printLevel=15;
    case RcdHeader::trigger:            _printLevel=18;
    case RcdHeader::event:              _printLevel=18;
      
    default:                            _printLevel=255;
    };
  }

protected:
  unsigned _printLevel;
};

#endif
