#ifndef RunMonitorShm_HH
#define RunMonitorShm_HH

#include <sys/types.h>
#include <unistd.h>
#include <time.h>

#include "DaqRunStart.hh"
#include "RunCount.hh"


class RunMonitorShm {

public:
  enum {
    shmKey=0x76543213
  };

  RunMonitorShm() {
  }

  DaqRunStart& runStart() {
    return _runStart;
  }

  void runStart(const DaqRunStart d) {
    _runStart=d;
  }

  RunCount& runCount() {
    return _runCount;
  }

private:
  DaqRunStart _runStart;
  RunCount _runCount;
};

#endif
