#include <iostream>

#include "RcdArena.hh"
#include "SubInserter.hh"

#include "AhcSlowReadout.hh"

using namespace std;


int main(int argc, const char **argv) {

  AhcSlowReadout asr;
  asr.printLevel(8);

  // Define record memory
  RcdArena arena;

  arena.initialise(RcdHeader::startUp);
  asr.record(arena);
  //      sleep(10);
    
  arena.initialise(RcdHeader::runStart);
  asr.record(arena);
  //  sleep(10);

  arena.initialise(RcdHeader::slowControl);
  asr.record(arena);
  //  sleep(10);

  for(unsigned i(0);;i++) {
    arena.initialise(RcdHeader::configurationStart);
    SubInserter inserter(arena);
    AhcSlowControlData *d(inserter.insert<AhcSlowControlData>(true));
    d->xPosition((i%2)*1000);
    d->yPosition(((i/2)%2)*2000);
    asr.record(arena);
    //  sleep(10);
    
    for(unsigned j(0);j<2;j++) {
      arena.initialise(RcdHeader::slowReadout);
      asr.record(arena);
      sleep(10);
    }
  }

  return 0;
}
