#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

#include <iostream>

#include "ShmObject.hh"
#include "RunMonitorShm.hh"
#include "UtlArguments.hh"

using namespace std;

bool continueJob=true;

void signalHandler(int signal) {
  std::cerr << "Process " << getpid() << " received signal "
            << signal << std::endl;
  continueJob=false;
}

int main(int argc, const char *argv[]) {
  //UtlArguments argh(argc,argv);
  //const unsigned sleepSecs(argh.optionArgument('s',5,"Sleep period (secs), 0 = do once"));
  //if(argh.help()) return 0;

  signal(SIGINT,signalHandler);
  signal(SIGTERM,signalHandler);

  ShmObject<RunMonitorShm> shmRunMonitor(RunMonitorShm::shmKey);
  RunMonitorShm *q(shmRunMonitor.payload());
  if(q==0) return 1;
  DaqRunStart *p(&(q->runStart()));
  if(p==0) return 2;

  p->print(std::cout);

  return 0;
}
