#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

#include <iostream>

#include "ShmObject.hh"
#include "RunMonitorShm.hh"
#include "UtlArguments.hh"

using namespace std;

bool continueJob=true;

void signalHandler(int signal) {
  std::cerr << "Process " << getpid() << " received signal "
            << signal << std::endl;
  continueJob=false;
}

int main(int argc, const char *argv[]) {
  UtlArguments argh(argc,argv);
  const unsigned sleepSecs(argh.optionArgument('s',5,"Sleep period (secs), 0 = do once"));
  if(argh.help()) return 0;

  signal(SIGINT,signalHandler);
  signal(SIGTERM,signalHandler);

  ShmObject<RunMonitorShm> shmRunMonitor(RunMonitorShm::shmKey);
  RunMonitorShm *q(shmRunMonitor.payload());
  if(q==0) return 1;
  RunCount *p(&(q->runCount()));
  if(p==0) return 1;

  UtlTime timeOld(true);

  unsigned eventsOld[2];
  unsigned eventsNew[2];
  eventsOld[0]=p->count(RcdHeader::trigger);
  eventsOld[1]=p->count(RcdHeader::event);

  unsigned rate[2];
  rate[0]=0;
  rate[1]=0;

  while(continueJob) {
    UtlTime timeNew(true);
    double delta((timeNew-timeOld).deltaTime());

    if(delta>3.0) {
      eventsNew[0]=p->count(RcdHeader::trigger);
      eventsNew[1]=p->count();

      rate[0]=(unsigned)(0.5+(eventsNew[0]-eventsOld[0])/delta);
      rate[1]=(unsigned)(0.5+(eventsNew[1]-eventsOld[1])/delta);

      timeOld=timeNew;
      eventsOld[0]=eventsNew[0];
      eventsOld[1]=eventsNew[1];
    }

    std::cout << timeNew << std::endl;
    p->print(std::cout);
    std::cout << std::endl 
	      << " Trigger, event rates = " << std::setw(6) << rate[0] 
	      << " Hz,  " << std::setw(6) << rate[1]
	      << " Hz" << std::endl << std::endl;

    if(sleepSecs>0) sleep(sleepSecs);
    else continueJob=false;
  }

  return 0;
}
