#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <iostream>

#include "UtlArguments.hh"
#include "RcdArena.hh"
#include "RcdIoSkt.hh"
#include "TrgReadout.hh"

using namespace std;

int main(int argc, const char **argv) {

  unsigned eTime(CALICE_DAQ_TIME);
  cout << argv[0] << " compiled at " << ctime((const time_t*)&eTime);
 
  UtlArguments argh(argc,argv);

  const unsigned pciCard(argh.optionArgument('p',0,"PCI card"));
  const unsigned crate(argh.optionArgument('c',0xec,"Crate"));
  const unsigned slot(argh.optionArgument('s',12,"Slot"));

  if(argh.help()) return 0;

  cout << "PCI card set to " << pciCard << endl;
  cout << "Crate set to 0x" << hex << crate << dec << endl;
  cout << "Slot set to " << slot << endl;

  RcdIoSkt s;
  TrgReadout c(pciCard,crate,slot);
  RcdArenas *r(new RcdArenas);
  r->initialise(RcdHeader::startUp);

  //while(true) {
    assert(s.open(1126));
    while(r->recordType()!=RcdHeader::shutDown) {
      assert(s.read(*r));
      //std::cout << "Read total bytes = " << r->totalNumberOfBytes() << std::endl;
      //      if(fork()==0) {
	assert(c.record(*r));
	//	exit(0);
	//} else {
	//int status(0);
	//wait(&status);
	//assert(status==0);
	//      }
      //std::cout << "Write total bytes = " << r->totalNumberOfBytes() << std::endl;

      assert(s.write(*r));
      //std::cout << "Write total bytes = " << r->totalNumberOfBytes() << std::endl;
    }
    assert(s.close());
    //  }

  return 0;
}
