#ifndef AhcFeConfigurationData_HH
#define AhcFeConfigurationData_HH

#include <string>
#include <iostream>

#include "CrcFeConfigurationData.hh"

#include "AhcVfeControl.hh"

class AhcFeConfigurationDataV0;


class AhcFeConfigurationData : public CrcFeConfigurationData {

public:
  enum {
    versionNumber=1
  };

  AhcFeConfigurationData();
  AhcFeConfigurationData(const AhcFeConfigurationDataV0 &a);

  AhcVfeControl vfeControl() const;
  void          vfeControl(AhcVfeControl v);

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  //AhcVfeControl _vfeControl;
};


#ifdef CALICE_DAQ_ICC

#include "AhcFeConfigurationDataV0.hh"


AhcFeConfigurationData::AhcFeConfigurationData() {
}

AhcFeConfigurationData::AhcFeConfigurationData(const AhcFeConfigurationDataV0 &a) {
  CrcFeConfigurationData::operator=(a);
  vfeControl(a.vfeControl());
}

AhcVfeControl AhcFeConfigurationData::vfeControl() const {
  return CrcFeConfigurationData::vfeControl();
}
 
void AhcFeConfigurationData::vfeControl(AhcVfeControl v) {
  CrcFeConfigurationData::vfeControl(v.data());
}

std::ostream& AhcFeConfigurationData::print(std::ostream &o, std::string s) const {
  o << s << "AhcFeConfigurationData::print()" << std::endl;

  CrcFeConfigurationData::print(o,s+" ");

  vfeControl().print(o,s+"  ");
  
  return o;
}

#endif
#endif
