#ifndef AhcSlowConfigurationData_HH
#define AhcSlowConfigurationData_HH

#include <string>
#include <iostream>


class AhcSlowConfigurationData {

public:
  enum {
    versionNumber=0
  };

  AhcSlowConfigurationData();

  bool parse(std::string r);
  
  time_t timeStamp() const;
  void   timeStamp(time_t t);

  int  xPosition() const;
  void xPosition(int x);

  double mmXPosition() const;
  void   mmXPosition(double x);

  int  yPosition() const;
  void yPosition(int y);

  double mmYPosition() const;
  void   mmYPosition(double y);

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  time_t _timeStamp;
  int _xPosition;
  int _yPosition;
};


#ifdef CALICE_DAQ_ICC

#include <time.h>
#include <cstring>


AhcSlowConfigurationData::AhcSlowConfigurationData() {
  memset(this,0,sizeof(AhcSlowConfigurationData));
}

bool AhcSlowConfigurationData::parse(std::string r) {
  std::istringstream sin(r);
  sin >> _timeStamp;
  if(!sin) return false;

  sin >> _xPosition;
  if(!sin) return false;

  sin >> _yPosition;
  return sin;
}

time_t AhcSlowConfigurationData::timeStamp() const {
  return _timeStamp;
}

void AhcSlowConfigurationData::timeStamp(time_t t) {
  _timeStamp=t;
}

int AhcSlowConfigurationData::xPosition() const {
  return _xPosition;
}

void AhcSlowConfigurationData::xPosition(int x) {
  _xPosition=x;
}

double AhcSlowConfigurationData::mmXPosition() const {
  return 0.1*_xPosition;
}

void AhcSlowConfigurationData::mmXPosition(double x) {
  _xPosition=(int)(10.0*x);
}

int AhcSlowConfigurationData::yPosition() const {
  return _yPosition;
}

void AhcSlowConfigurationData::yPosition(int y) {
  _yPosition=y;
}

double AhcSlowConfigurationData::mmYPosition() const {
  return 0.1*_yPosition;
}

void AhcSlowConfigurationData::mmYPosition(double y) {
  _yPosition=(int)(10.0*y);
}

std::ostream& AhcSlowConfigurationData::print(std::ostream &o, std::string s) const {
  o << s << "AhcSlowConfigurationData::print()" << std::endl;
  o << s << " Timestamp = " << _timeStamp << " = " << ctime(&_timeStamp);
  o << s << " X position = " << std::setw(6) << _xPosition << " x 0.1 mm = "
    << std::setw(6) << mmXPosition() << " mm" << std::endl;
  o << s << " Y position = " << std::setw(6) << _yPosition << " x 0.1 mm = "
    << std::setw(6) << mmYPosition() << " mm" << std::endl;

  return o;
}

#endif
#endif
