#ifndef AhcSlowRunData_HH
#define AhcSlowRunData_HH

#include <string>
#include <iostream>


class AhcSlowRunData {

public:
  enum {
    versionNumber=0
  };

  AhcSlowRunData();

  bool parse(std::string r);
  
  time_t timeStamp() const;
  void   timeStamp(time_t t);

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  time_t _timeStamp;
};


#ifdef CALICE_DAQ_ICC

#include <time.h>
#include <cstring>


AhcSlowRunData::AhcSlowRunData() {
  memset(this,0,sizeof(AhcSlowRunData));
}

bool AhcSlowRunData::parse(std::string r) {
  std::istringstream sin(r);
  sin >> _timeStamp;
  return sin;
}

time_t AhcSlowRunData::timeStamp() const {
  return _timeStamp;
}

void AhcSlowRunData::timeStamp(time_t t) {
  _timeStamp=t;
}

std::ostream& AhcSlowRunData::print(std::ostream &o, std::string s) const {
  o << s << "AhcSlowRunData::print()" << std::endl;
  o << s << " Timestamp = " << _timeStamp << " = " << ctime(&_timeStamp);

  return o;
}

#endif
#endif
