#ifndef BmlCaen767ConfigurationData_HH
#define BmlCaen767ConfigurationData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class BmlCaen767ConfigurationData {

public:
  enum {
    versionNumber=0
  };

  BmlCaen767ConfigurationData();

  unsigned char baseAddress() const;
  void baseAddress(unsigned char b);

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  UtlPack _data;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


BmlCaen767ConfigurationData::BmlCaen767ConfigurationData() {
  memset(this,0,sizeof(BmlCaen767ConfigurationData));
}

unsigned char BmlCaen767ConfigurationData::baseAddress() const {
  return _data.byte(0);
}

void BmlCaen767ConfigurationData::baseAddress(unsigned char b) {
  _data.word(0);
  _data.byte(0,b);
}

std::ostream& BmlCaen767ConfigurationData::print(std::ostream &o, std::string s) const {
  o << s << "BmlCaen767ConfigurationData::print()" << std::endl;
  o << s << " Data = " << printHex(_data.word()) << std::endl;
  return o;
}

#endif
#endif
