#ifndef BmlCaen767EventData_HH
#define BmlCaen767EventData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class BmlCaen767EventData {

public:
  enum {
    versionNumber=0
  };

  BmlCaen767EventData();

  unsigned numberOfWords() const;
  void     numberOfWords(unsigned n);
  
  const unsigned* data() const;
  unsigned*       data();
 
  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  unsigned _numberOfWords;
  UtlPack _data[1];
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


BmlCaen767EventData::BmlCaen767EventData() {
  memset(this,0,sizeof(BmlCaen767EventData));
}

unsigned BmlCaen767EventData::numberOfWords() const {
  return _numberOfWords;
}

void BmlCaen767EventData::numberOfWords(unsigned n) {
  _numberOfWords=n;
}

const unsigned* BmlCaen767EventData::data() const {
  return (const unsigned*)_data;
}

unsigned* BmlCaen767EventData::data() {
  return (unsigned*)_data;
}

std::ostream& BmlCaen767EventData::print(std::ostream &o, std::string s) const {
  o << s << "BmlCaen767EventData::print()" << std::endl;
  o << s << " Number of words = " << _numberOfWords << std::endl;
  for(unsigned i(0);i<_numberOfWords;i++) {
    o << s << " Data word " << std::setw(4) << i
      << " = " << printHex(_data[i]) << std::endl;

    // Header 
    if(_data[i].bit(22) && !_data[i].bit(21)) {
      o << s << "  Header: Geo Address = " << printHex(_data[i].bits(27,31))
	<< ", Event Number = " << _data[i].bits(0,12) << std::endl;
    }

    // Data
    if(_data[i].bit(22) && !_data[i].bit(21)) {
      o << s << "  Data: Channel = " << printHex(_data[i].bits(24,30));
      if(_data[i].bit(23)) o << ", Start";
      if(_data[i].bit(20)) o << ", Leading ";
      else                 o << ", Trailing";
      o << ", Time = " << _data[i].bits(0,19) << std::endl;
    }

    // EOB
    if(!_data[i].bit(22) && _data[i].bit(21)) {
      o << s << "  EOB: Geo Address = " << printHex(_data[i].bits(27,31))
	<< ", Status = " << _data[i].bits(24,26)
	<< ", Event Data Counter = " << _data[i].halfWord(0) << std::endl;
    }

    // Invalid
    if(!_data[i].bit(22) && _data[i].bit(21)) {
      o << s << "  Invalid data" << std::endl;
    }
  }
  return o;
}

#endif
#endif
