#ifndef BmlCaen767EventDatum_HH
#define BmlCaen767EventDatum_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class BmlCaen767EventDatum {

public:
  BmlCaen767EventDatum();

  enum Label {
    datum,
    header,
    trailer,
    invalid
  };

  Label label() const;
  
  unsigned char geoAddress() const;

  unsigned short eventNumber() const;

  unsigned char channel() const;

  unsigned time() const;

  unsigned short eventDataCounter() const;

  unsigned char status() const;

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  UtlPack _datum;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


BmlCaen767EventDatum::BmlCaen767EventDatum() {
  memset(this,0,sizeof(BmlCaen767EventDatum));
}


BmlCaen767EventDatum::Label BmlCaen767EventDatum::label() const {
  return (Label)_datum.bits(21,22);
}

unsigned char BmlCaen767EventDatum::geoAddress() const {
  if(label()!=header && label()!=trailer) return 0;
  return _datum.bits(27,31);
}

unsigned short BmlCaen767EventDatum::eventNumber() const {
  if(label()!=header) return 0;
  return _datum.bits(0,11);
}

unsigned char BmlCaen767EventDatum::channel() const {
  if(label()!=datum) return 0;
  return _datum.bits(24,30);
}

unsigned BmlCaen767EventDatum::time() const {
  if(label()!=datum) return 0;
  return _datum.bits(0,19);
}

unsigned short BmlCaen767EventDatum::eventDataCounter() const {
  if(label()!=trailer) return 0;
  return _datum.halfWord(0);
}

unsigned char BmlCaen767EventDatum::status() const {
  if(label()!=trailer) return 0;
  return _datum.bits(24,26);
}

std::ostream& BmlCaen767EventDatum::print(std::ostream &o, std::string s) const {
  o << s << "BmlCaen767EventDatum::print()" << std::endl;
  o << s << " Data word = " << printHex(_data[i]) << std::endl;
  
    // Header 
  if(label()==header) {
      o << s << "  Header: Geo Address = " << printHex(_data[i].bits(27,31))
	<< ", Event Number = " << _data[i].bits(0,12) << std::endl;
    }

    // Data
    if(_data[i].bit(22) && !_data[i].bit(21)) {
      o << s << "  Data: Channel = " << printHex(_data[i].bits(24,30));
      if(_data[i].bit(23)) o << ", Start";
      if(_data[i].bit(20)) o << ", Leading ";
      else                 o << ", Trailing";
      o << ", Time = " << _data[i].bits(0,19) << std::endl;
    }

    // EOB
    if(!_data[i].bit(22) && _data[i].bit(21)) {
      o << s << "  EOB: Geo Address = " << printHex(_data[i].bits(27,31))
	<< ", Status = " << _data[i].bits(24,26) << std::endl;
	<< ", Event Data Counter = " << _data[i].halfWord(0) << std::endl;
    }

    // Invalid
    if(!_data[i].bit(22) && _data[i].bit(21)) {
      o << s << "  Invalid data" << std::endl;
    }
  }
  return o;
}

#endif
#endif
