#ifndef BmlCaen767RunData_HH
#define BmlCaen767RunData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class BmlCaen767RunData {

public:
  enum {
    versionNumber=0
  };

  BmlCaen767RunData();

  unsigned short baseAddress() const;
  void baseAddress(unsigned short b);

  std::string manufacturerId() const;
  void        manufacturerId(std::string m);

  std::string boardId() const;
  void        boardId(std::string b);

  unsigned short revisionId() const;
  void           revisionId(unsigned short r);

  unsigned short serialNumber() const;
  void           serialNumber(unsigned short s);

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  UtlPack _baseAddress;
  char _manufacturerId[12];
  char _boardId[16];
  UtlPack _revSer;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


BmlCaen767RunData::BmlCaen767RunData() {
  memset(this,0,sizeof(BmlCaen767RunData));
}

unsigned short BmlCaen767RunData::baseAddress() const {
  return _baseAddress.halfWord(0);
}

void BmlCaen767RunData::baseAddress(unsigned short b) {
  _baseAddress.halfWord(0,b);
}

std::string BmlCaen767RunData::manufacturerId() const {
  return _manufacturerId;
}

void BmlCaen767RunData::manufacturerId(std::string m) {
  for(unsigned i(0);i<10;i++) _manufacturerId[i]=m[i];
  _manufacturerId[10]='\0';
  _manufacturerId[11]='\0';
}

std::string BmlCaen767RunData::boardId() const {
  return _boardId;
}

void BmlCaen767RunData::boardId(std::string b) {
  for(unsigned i(0);i<14;i++) _boardId[i]=b[i];
  _boardId[14]='\0';
  _boardId[15]='\0';
}

unsigned short BmlCaen767RunData::revisionId() const {
  return _revSer.halfWord(0);
}

void BmlCaen767RunData::revisionId(unsigned short r) {
  _revSer.halfWord(0,r);
}

unsigned short BmlCaen767RunData::serialNumber() const {
  return _revSer.halfWord(1);
}

void BmlCaen767RunData::serialNumber(unsigned short s) {
  _revSer.halfWord(1,s);
}

std::ostream& BmlCaen767RunData::print(std::ostream &o, std::string s) const {
  o << s << "BmlCaen767RunData::print()" << std::endl;
  o << s << " Base Address = " << printHex(baseAddress()) << std::endl;
  o << s << " Manufacturer Id = " << manufacturerId() << std::endl;
  o << s << " Board Id = " << boardId() << std::endl;
  o << s << " Revision Id = " << printHex(baseAddress()) << std::endl;
  o << s << " Serial Number = " << printHex(baseAddress()) << std::endl;
  return o;
}

#endif
#endif
