#ifndef BmlLocation_HH
#define BmlLocation_HH

#include <string>
#include <iostream>

#include "UtlLocation.hh"

class BmlLocation : public UtlLocation {

public:
  BmlLocation();
  BmlLocation(unsigned char c, unsigned a, unsigned char l=0);
  
  unsigned baseAddress() const;
  void     baseAddress(unsigned a);

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
};


#ifdef CALICE_DAQ_ICC

#include "UtlPrintHex.hh"

BmlLocation::BmlLocation() : UtlLocation() {
}

BmlLocation::BmlLocation(unsigned char c, unsigned a, unsigned char l) : 
  UtlLocation(c,0,0,l) {
  baseAddress(a);
}

unsigned BmlLocation::baseAddress() const {
  UtlPack a(0);
  a.byte(3,slotNumber());
  a.byte(2,componentNumber());
  return a.word();
}
  
void BmlLocation::baseAddress(unsigned a) {
  UtlPack ap(a);
  slotNumber(ap.byte(3));
  componentNumber(ap.byte(2));
}
  
std::ostream& BmlLocation::print(std::ostream &o, std::string s) const {
  o << s << "BmlLocation::print()" << std::endl;

  o << s << " Crate number     = "
    << printHex(crateNumber(),false) << std::endl;

  o << s << " Base address     = " << std::setw(4)
    << printHex(baseAddress(),false) << std::endl;

  o << s << " Label            = " << printHex(label());
  if(write()) o << " = write";
  else        o << " = read";
  if(ignore()) o << ", ignore";
  o << std::endl;

  return o;
}

#endif
#endif
