#ifndef SubRecordType_HH
#define SubRecordType_HH

#include <string>

template<class Payload> unsigned subRecordType();

// record/inc/daq
#include "DaqRunStart.hh"
#include "DaqSequenceStart.hh"
#include "DaqConfigurationStartV0.hh"
#include "DaqConfigurationStartV1.hh"
#include "DaqConfigurationStart.hh"
#include "DaqAcquisitionStartV0.hh"
#include "DaqAcquisitionStart.hh"
#include "DaqSlowReadout.hh"
#include "DaqSpillStart.hh"
#include "DaqEvent.hh"
#include "DaqSpillEnd.hh"
#include "DaqTransferStart.hh"
#include "DaqTransferEnd.hh"
#include "DaqAcquisitionEndV0.hh"
#include "DaqAcquisitionEnd.hh"
#include "DaqConfigurationEndV0.hh"
#include "DaqConfigurationEnd.hh"
#include "DaqSequenceEnd.hh"
#include "DaqRunEndV0.hh"
#include "DaqRunEnd.hh"
#include "DaqMessage.hh"
#include "DaqSoftware.hh"
//#include "DaqStartUp.hh"
//#include "DaqStateData.hh"

// record/inc/crc
#include "CrcLocationData.hh"

#include "CrcVmeRunData.hh"
#include "CrcVmeConfigurationData.hh"
#include "CrcVmeEventData.hh"

#include "CrcBeRunData.hh"
#include "CrcBeConfigurationData.hh"
#include "CrcBeEventDataV0.hh"
#include "CrcBeEventData.hh"

#include "CrcFeRunData.hh"
#include "CrcFeConfigurationData.hh"
#include "CrcFeEventData.hh"

#include "CrcFeFakeEventData.hh"
#include "CrcVlinkEventData.hh"

#include "CrcLm82RunData.hh"
#include "CrcLm82ConfigurationData.hh"
#include "CrcLm82SlowReadoutData.hh"

#include "CrcAdm1025RunData.hh"
#include "CrcAdm1025ConfigurationData.hh"
#include "CrcAdm1025SlowReadoutData.hh"

//#include "CrcReadoutStartupData.hh"
#include "CrcReadoutConfigurationDataV0.hh"
#include "CrcReadoutConfigurationData.hh"

#include "CrcBeTrgRunData.hh"
#include "CrcBeTrgConfigurationData.hh"
#include "CrcBeTrgEventData.hh"
#include "CrcBeTrgPollDataV0.hh"
#include "CrcBeTrgPollData.hh"
#include "TrgSpillPollData.hh"

//#include "TrgReadoutStartupData.hh"
#include "TrgReadoutConfigurationData.hh"

// record/inc/emc
#include "EmcFeConfigurationData.hh"
#include "EmcStageRunData.hh"

// record/inc/ahc
#include "AhcFeConfigurationDataV0.hh"
#include "AhcFeConfigurationData.hh"
#include "AhcVfeStartUpData.hh"
#include "AhcVfeConfigurationData.hh"
#include "AhcSlowRunData.hh"
#include "AhcSlowConfigurationData.hh"
#include "AhcSlowReadoutData.hh"

// record/inc/bml
#include "BmlLocationData.hh"

#include "BmlLc1176RunData.hh"
#include "BmlLc1176ConfigurationData.hh"
#include "BmlLc1176EventData.hh"

#include "BmlCaen767RunData.hh"
#include "BmlCaen767ConfigurationData.hh"
#include "BmlCaen767EventData.hh"

#include "BmlHodRunData.hh"
#include "BmlHodEventData.hh"

// record/inc/sub
#include "SubHeader.hh"


// DAQ

template<> unsigned subRecordType<DaqRunStart>() {
  return SubHeader::daq+0x000+DaqRunStart::versionNumber;
}

template<> unsigned subRecordType<DaqRunEndV0>() {
  return SubHeader::daq+0x010+DaqRunEndV0::versionNumber;
}

template<> unsigned subRecordType<DaqRunEndV1>() {
  return SubHeader::daq+0x010+DaqRunEndV1::versionNumber;
}

template<> unsigned subRecordType<DaqConfigurationStartV0>() {
  return SubHeader::daq+0x020+DaqConfigurationStartV0::versionNumber;
}

template<> unsigned subRecordType<DaqConfigurationStartV1>() {
  return SubHeader::daq+0x020+DaqConfigurationStartV1::versionNumber;
}

template<> unsigned subRecordType<DaqConfigurationStartV2>() {
  return SubHeader::daq+0x020+DaqConfigurationStartV2::versionNumber;
}

template<> unsigned subRecordType<DaqConfigurationEndV0>() {
  return SubHeader::daq+0x030+DaqConfigurationEndV0::versionNumber;
}

template<> unsigned subRecordType<DaqConfigurationEndV1>() {
  return SubHeader::daq+0x030+DaqConfigurationEndV1::versionNumber;
}

template<> unsigned subRecordType<DaqAcquisitionStartV0>() {
  return SubHeader::daq+0x040+DaqAcquisitionStartV0::versionNumber;
}

template<> unsigned subRecordType<DaqAcquisitionStartV1>() {
  return SubHeader::daq+0x040+DaqAcquisitionStartV1::versionNumber;
}

template<> unsigned subRecordType<DaqAcquisitionEndV0>() {
  return SubHeader::daq+0x050+DaqAcquisitionEndV0::versionNumber;
}

template<> unsigned subRecordType<DaqAcquisitionEndV1>() {
  return SubHeader::daq+0x050+DaqAcquisitionEndV1::versionNumber;
}

template<> unsigned subRecordType<DaqEvent>() {
  return SubHeader::daq+0x060+DaqEvent::versionNumber;
}

template<> unsigned subRecordType<DaqSpillStart>() {
  return SubHeader::daq+0x070+DaqSpillStart::versionNumber;
}

template<> unsigned subRecordType<DaqSpillEnd>() {
  return SubHeader::daq+0x080+DaqSpillEnd::versionNumber;
}

template<> unsigned subRecordType<DaqTransferStart>() {
  return SubHeader::daq+0x090+DaqTransferStart::versionNumber;
}

template<> unsigned subRecordType<DaqTransferEnd>() {
  return SubHeader::daq+0x0a0+DaqTransferEnd::versionNumber;
}

template<> unsigned subRecordType<DaqMessage>() {
  return SubHeader::daq+0x0b0+DaqMessage::versionNumber;
}

template<> unsigned subRecordType<DaqSoftware>() {
  return SubHeader::daq+0x0c0+DaqSoftware::versionNumber;
}

template<> unsigned subRecordType<DaqSlowReadout>() {
  return SubHeader::daq+0x0d0+DaqSlowReadout::versionNumber;
}

template<> unsigned subRecordType<DaqSequenceStart>() {
  return SubHeader::daq+0x0e0+DaqSequenceStart::versionNumber;
}

template<> unsigned subRecordType<DaqSequenceEnd>() {
  return SubHeader::daq+0x0f0+DaqSequenceEnd::versionNumber;
}

// CRC

template<> unsigned subRecordType<CrcLocationData <CrcVmeRunData> >() {
  return SubHeader::crc+0x000+CrcVmeRunData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcVmeConfigurationData> >() {
  return SubHeader::crc+0x010+CrcVmeConfigurationData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcVmeEventData> >() {
  return SubHeader::crc+0x020+CrcVmeEventData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcBeRunData> >() {
  return SubHeader::crc+0x030+CrcBeRunData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcBeConfigurationData> >() {
  return SubHeader::crc+0x040+CrcBeConfigurationData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcBeEventDataV0> >() {
  return SubHeader::crc+0x050+CrcBeEventDataV0::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcBeEventData> >() {
  return SubHeader::crc+0x050+CrcBeEventData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcFeRunData> >() {
  return SubHeader::crc+0x060+CrcFeRunData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcFeConfigurationData> >() {
  return SubHeader::crc+0x070+CrcFeConfigurationData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcFeEventData> >() {
  return SubHeader::crc+0x080+CrcFeEventData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcVlinkEventData> >() {
  return SubHeader::crc+0x100+CrcVlinkEventData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcFeFakeEventData> >() {
  return SubHeader::crc+0x110+CrcFeFakeEventData::versionNumber;
}

template<> unsigned subRecordType<CrcReadoutConfigurationDataV0>() {
  return SubHeader::crc+0x200+CrcReadoutConfigurationDataV0::versionNumber;
}

template<> unsigned subRecordType<CrcReadoutConfigurationData>() {
  return SubHeader::crc+0x200+CrcReadoutConfigurationData::versionNumber;
}

//template<> unsigned subRecordType<CrcReadoutStartupData>() {
//  return SubHeader::trg+0x210+CrcReadoutStartupData::versionNumber;
//}

// EMC

template<> unsigned subRecordType<CrcLocationData <EmcFeConfigurationData> >() {
  return SubHeader::emc+0x000+EmcFeConfigurationData::versionNumber;
}


// AHC

template<> unsigned subRecordType<CrcLocationData <AhcFeConfigurationDataV0> >() {
  return SubHeader::ahc+0x000+AhcFeConfigurationDataV0::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <AhcFeConfigurationData> >() {
  return SubHeader::ahc+0x000+AhcFeConfigurationData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <AhcVfeConfigurationData> >() {
  return SubHeader::ahc+0x010+AhcVfeConfigurationData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <AhcVfeStartUpData> >() {
  return SubHeader::ahc+0x020+AhcVfeStartUpData::versionNumber;
}

template<> unsigned subRecordType<AhcSlowRunData>() {
  return SubHeader::ahc+0x030+AhcSlowRunData::versionNumber;
}

template<> unsigned subRecordType<AhcSlowConfigurationData>() {
  return SubHeader::ahc+0x040+AhcSlowConfigurationData::versionNumber;
}

template<> unsigned subRecordType<AhcSlowReadoutData>() {
  return SubHeader::ahc+0x050+AhcSlowReadoutData::versionNumber;
}


// BML

template<> unsigned subRecordType<BmlLc1176RunData>() {
  return SubHeader::bml+0x000+BmlLc1176RunData::versionNumber;
}

template<> unsigned subRecordType<BmlLc1176ConfigurationData>() {
  return SubHeader::bml+0x010+BmlLc1176ConfigurationData::versionNumber;
}

template<> unsigned subRecordType<BmlLc1176EventData>() {
  return SubHeader::bml+0x020+BmlLc1176EventData::versionNumber;
}

template<> unsigned subRecordType<BmlHodRunData>() {
  return SubHeader::bml+0x030+BmlHodRunData::versionNumber;
}
/*
template<> unsigned subRecordType<BmlHodConfigurationData>() {
  return SubHeader::bml+0x040+BmlHodConfigurationData::versionNumber;
}
*/
template<> unsigned subRecordType<BmlHodEventData>() {
  return SubHeader::bml+0x050+BmlHodEventData::versionNumber;
}

template<> unsigned subRecordType<BmlLocationData <BmlCaen767RunData> >() {
  return SubHeader::bml+0x000+BmlCaen767RunData::versionNumber;
}

template<> unsigned subRecordType<BmlLocationData <BmlCaen767ConfigurationData> >() {
  return SubHeader::bml+0x010+BmlCaen767ConfigurationData::versionNumber;
}

template<> unsigned subRecordType<BmlLocationData <BmlCaen767EventData> >() {
  return SubHeader::bml+0x020+BmlCaen767EventData::versionNumber;
}



// TRG

template<> unsigned subRecordType<CrcLocationData <CrcBeTrgRunData> >() {
  return SubHeader::trg+0x000+CrcBeTrgRunData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcBeTrgConfigurationData> >() {
  return SubHeader::trg+0x010+CrcBeTrgConfigurationData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcBeTrgEventData> >() {
  return SubHeader::trg+0x020+CrcBeTrgEventData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcBeTrgPollDataV0> >() {
  return SubHeader::trg+0x030+CrcBeTrgPollDataV0::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcBeTrgPollDataV1> >() {
  return SubHeader::trg+0x030+CrcBeTrgPollDataV1::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <TrgSpillPollData> >() {
  return SubHeader::trg+0x040+TrgSpillPollData::versionNumber;
}

//template<> unsigned subRecordType<TrgReadoutStartupData>() {
//  return SubHeader::trg+0x200+TrgReadoutStartupData::versionNumber;
//}

template<> unsigned subRecordType<TrgReadoutConfigurationData>() {
  return SubHeader::trg+0x210+TrgReadoutConfigurationData::versionNumber;
}


// SLW

template<> unsigned subRecordType<CrcLocationData <CrcLm82RunData> >() {
  return SubHeader::slw+0x000+CrcLm82RunData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcLm82ConfigurationData> >() {
  return SubHeader::slw+0x010+CrcLm82ConfigurationData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcLm82SlowReadoutData> >() {
  return SubHeader::slw+0x020+CrcLm82SlowReadoutData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcAdm1025RunData> >() {
  return SubHeader::slw+0x030+CrcAdm1025RunData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcAdm1025ConfigurationData> >() {
  return SubHeader::slw+0x040+CrcAdm1025ConfigurationData::versionNumber;
}

template<> unsigned subRecordType<CrcLocationData <CrcAdm1025SlowReadoutData> >() {
  return SubHeader::slw+0x050+CrcAdm1025SlowReadoutData::versionNumber;
}

template<> unsigned subRecordType<EmcStageRunData>() {
  return SubHeader::slw+0x060+EmcStageRunData::versionNumber;
}

#ifdef CALICE_DAQ_ICC
#endif
#endif
