#ifndef ChkPrint_HH
#define ChkPrint_HH

#include <iostream>
#include <fstream>

#include "CrcVmeRunData.hh"
#include "CrcBeRunData.hh"
#include "CrcBeTrgRunData.hh"
#include "CrcFeRunData.hh"

#include "RcdHeader.hh"
#include "SubInserter.hh"
#include "SubAccessor.hh"
#include "SubRecordType.hh"


class ChkPrint {

public:
  ChkPrint() : _printLevel(4) {
    enableSubrecords(false);
    enableType(false);
    enable(false);
  }

  virtual ~ChkPrint() {
  }

  void enableSubrecords(bool e) {
    _selectSubrecords=e;
  }

  void enableType(bool e) {
    for(unsigned i(0);i<RcdHeader::endOfRecordTypeEnum;i++) _selectType[i]=e;
  }

  void enableType(RcdHeader::RecordType t, bool e) {
    _selectType[t]=e;
  }

  void enable(bool e) {
    for(unsigned i(0);i<65536;i++) _select[i]=e;
  }

  void enable(SubHeader::Group g, bool e) {
    for(unsigned i(0);i<4096;i++) _select[g+i]=e;
  }

  void enable(unsigned short n, bool e) {
    _select[n]=e;
  }

  void record(const RcdRecord &r) {

    SubAccessor accessor(r);

    // Print out header
    if(_selectType[r.recordType()]) r.RcdHeader::print(std::cout) << std::endl;

    // Print out SubHeader information for all subrecords
    if(_selectSubrecords) accessor.print(std::cout) << std::endl;

    // Print out each subrecord individually
    // The template below should make this simpler but does not compile!

    // daq subrecords

    if(_select[subRecordType< DaqRunStart >()]) {
      std::vector<const DaqRunStart*>
	v(accessor.access<DaqRunStart>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    
    if(_select[subRecordType< DaqRunEnd >()]) {
      std::vector<const DaqRunEnd*>
	v(accessor.access<DaqRunEnd>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqConfigurationStart >()]) {
      std::vector<const DaqConfigurationStart*>
	v(accessor.access<DaqConfigurationStart>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqConfigurationEnd >()]) {
      std::vector<const DaqConfigurationEnd*>
	v(accessor.access<DaqConfigurationEnd>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqAcquisitionStart >()]) {
      std::vector<const DaqAcquisitionStart*>
	v(accessor.access<DaqAcquisitionStart>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqAcquisitionEnd >()]) {
      std::vector<const DaqAcquisitionEnd*>
	v(accessor.access<DaqAcquisitionEnd>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqEvent >()]) {
      std::vector<const DaqEvent*>
	v(accessor.access<DaqEvent>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqSpillStart >()]) {
      std::vector<const DaqSpillStart*>
	v(accessor.access<DaqSpillStart>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqSpillEnd >()]) {
      std::vector<const DaqSpillEnd*>
	v(accessor.access<DaqSpillEnd>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqTransferStart >()]) {
      std::vector<const DaqTransferStart*>
	v(accessor.access<DaqTransferStart>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqTransferEnd >()]) {
      std::vector<const DaqTransferEnd*>
	v(accessor.access<DaqTransferEnd>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqMessage >()]) {
      std::vector<const DaqMessage*>
	v(accessor.access<DaqMessage>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqSoftware >()]) {
      std::vector<const DaqSoftware*>
	v(accessor.access<DaqSoftware>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqSlowReadout >()]) {
      std::vector<const DaqSlowReadout*>
	v(accessor.access<DaqSlowReadout>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqSequenceStart >()]) {
      std::vector<const DaqSequenceStart*>
	v(accessor.access<DaqSequenceStart>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< DaqSequenceEnd >()]) {
      std::vector<const DaqSequenceEnd*>
	v(accessor.access<DaqSequenceEnd>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }


    // crc subrecords

    if(_select[subRecordType< CrcLocationData<CrcVmeRunData> >()]) {
      std::vector<const CrcLocationData<CrcVmeRunData>*>
	v(accessor.access<CrcLocationData<CrcVmeRunData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcVmeConfigurationData> >()]) {
      std::vector<const CrcLocationData<CrcVmeConfigurationData>*>
	v(accessor.access<CrcLocationData<CrcVmeConfigurationData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcVmeEventData> >()]) {
      std::vector<const CrcLocationData<CrcVmeEventData>*>
	v(accessor.access<CrcLocationData<CrcVmeEventData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcBeRunData> >()]) {
      std::vector<const CrcLocationData<CrcBeRunData>*>
	v(accessor.access<CrcLocationData<CrcBeRunData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcBeConfigurationData> >()]) {
      std::vector<const CrcLocationData<CrcBeConfigurationData>*>
	v(accessor.access<CrcLocationData<CrcBeConfigurationData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcBeEventData> >()]) {
      std::vector<const CrcLocationData<CrcBeEventData>*>
	v(accessor.access<CrcLocationData<CrcBeEventData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    
    if(_select[subRecordType< CrcLocationData<CrcFeRunData> >()]) {
      std::vector<const CrcLocationData<CrcFeRunData>*>
	v(accessor.access<CrcLocationData<CrcFeRunData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcFeConfigurationData> >()]) {
      std::vector<const CrcLocationData<CrcFeConfigurationData>*>
	v(accessor.access<CrcLocationData<CrcFeConfigurationData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    
    if(_select[subRecordType< CrcLocationData<CrcFeEventData> >()]) {
      std::vector<const CrcLocationData<CrcFeEventData>*>
	v(accessor.access<CrcLocationData<CrcFeEventData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcVlinkEventData> >()]) {
      std::vector<const CrcLocationData<CrcVlinkEventData>*>
	v(accessor.access<CrcLocationData<CrcVlinkEventData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
	v[i]->data()->print(std::cout,"",true) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcFeFakeEventData> >()]) {
      std::vector<const CrcLocationData<CrcFeFakeEventData>*>
	v(accessor.access<CrcLocationData<CrcFeFakeEventData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcReadoutConfigurationData >()]) {
      std::vector<const CrcReadoutConfigurationData*>
	v(accessor.access<CrcReadoutConfigurationData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    

    // emc subrecords

    if(_select[subRecordType< CrcLocationData<EmcFeConfigurationData> >()]) {
      std::vector<const CrcLocationData<EmcFeConfigurationData>*>
	v(accessor.access<CrcLocationData<EmcFeConfigurationData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    
    if(_select[subRecordType<EmcStageRunData>()]) {
      std::vector<const EmcStageRunData*>
	v(accessor.access<EmcStageRunData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }


    // ahc subrecords

    if(_select[subRecordType< CrcLocationData<AhcFeConfigurationData> >()]) {
      std::vector<const CrcLocationData<AhcFeConfigurationData>*>
	v(accessor.access<CrcLocationData<AhcFeConfigurationData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<AhcVfeConfigurationData> >()]) {
      std::vector<const CrcLocationData<AhcVfeConfigurationData>*>
       v(accessor.access<CrcLocationData<AhcVfeConfigurationData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<AhcVfeStartUpData> >()]) {
      std::vector<const CrcLocationData<AhcVfeStartUpData>*>
       v(accessor.access<CrcLocationData<AhcVfeStartUpData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType<AhcSlowRunData>()]) {
      std::vector<const AhcSlowRunData*>
       v(accessor.access<AhcSlowRunData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType<AhcSlowConfigurationData>()]) {
      std::vector<const AhcSlowConfigurationData*>
       v(accessor.access<AhcSlowConfigurationData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType<AhcSlowReadoutData>()]) {
      std::vector<const AhcSlowReadoutData*>
       v(accessor.access<AhcSlowReadoutData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }


    // bml subrecords

    if(_select[subRecordType< BmlLc1176RunData >()]) {
      std::vector<const BmlLc1176RunData*>
	v(accessor.access<BmlLc1176RunData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< BmlLc1176ConfigurationData >()]) {
      std::vector<const BmlLc1176ConfigurationData*>
	v(accessor.access<BmlLc1176ConfigurationData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< BmlLc1176EventData >()]) {
      std::vector<const BmlLc1176EventData*>
	v(accessor.access<BmlLc1176EventData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< BmlHodRunData >()]) {
      std::vector<const BmlHodRunData*>
	v(accessor.access<BmlHodRunData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< BmlHodEventData >()]) {
      std::vector<const BmlHodEventData*>
	v(accessor.access<BmlHodEventData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< BmlLocationData<BmlCaen767RunData> >()]) {
      std::vector<const BmlLocationData<BmlCaen767RunData>*>
	v(accessor.access<BmlLocationData<BmlCaen767RunData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< BmlLocationData<BmlCaen767OpcodeData> >()]) {
      std::vector<const BmlLocationData<BmlCaen767OpcodeData>*>
	v(accessor.access<BmlLocationData<BmlCaen767OpcodeData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< BmlLocationData<BmlCaen767ConfigurationData> >()]) {
      std::vector<const BmlLocationData<BmlCaen767ConfigurationData>*>
	v(accessor.access<BmlLocationData<BmlCaen767ConfigurationData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< BmlLocationData<BmlCaen767TriggerData> >()]) {
      std::vector<const BmlLocationData<BmlCaen767TriggerData>*>
	v(accessor.access<BmlLocationData<BmlCaen767TriggerData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< BmlLocationData<BmlCaen767EventData> >()]) {
      std::vector<const BmlLocationData<BmlCaen767EventData>*>
	v(accessor.access<BmlLocationData<BmlCaen767EventData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }


    // trg subrecords

    if(_select[subRecordType< CrcLocationData<CrcBeTrgRunData> >()]) {
      std::vector<const CrcLocationData<CrcBeTrgRunData>*>
	v(accessor.access<CrcLocationData<CrcBeTrgRunData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcBeTrgConfigurationData> >()]) {
      std::vector<const CrcLocationData<CrcBeTrgConfigurationData>*>
	v(accessor.access<CrcLocationData<CrcBeTrgConfigurationData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    
    if(_select[subRecordType< CrcLocationData<CrcBeTrgEventData> >()]) {
      std::vector<const CrcLocationData<CrcBeTrgEventData>*>
	v(accessor.access<CrcLocationData<CrcBeTrgEventData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    
    if(_select[subRecordType< CrcLocationData<CrcBeTrgPollData> >()]) {
      std::vector<const CrcLocationData<CrcBeTrgPollData>*>
	v(accessor.access<CrcLocationData<CrcBeTrgPollData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    
    if(_select[subRecordType< CrcLocationData<TrgSpillPollData> >()]) {
      std::vector<const CrcLocationData<TrgSpillPollData>*>
	v(accessor.access<CrcLocationData<TrgSpillPollData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    
    if(_select[subRecordType< TrgReadoutConfigurationData >()]) {
      std::vector<const TrgReadoutConfigurationData*>
	v(accessor.access<TrgReadoutConfigurationData>());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    

    // slw subrecords

    if(_select[subRecordType< CrcLocationData<CrcLm82RunData> >()]) {
      std::vector<const CrcLocationData<CrcLm82RunData>*>
	v(accessor.access<CrcLocationData<CrcLm82RunData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcLm82ConfigurationData> >()]) {
      std::vector<const CrcLocationData<CrcLm82ConfigurationData>*>
	v(accessor.access<CrcLocationData<CrcLm82ConfigurationData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcLm82SlowReadoutData> >()]) {
      std::vector<const CrcLocationData<CrcLm82SlowReadoutData>*>
       v(accessor.access<CrcLocationData<CrcLm82SlowReadoutData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcAdm1025RunData>  >()]) {
      std::vector<const CrcLocationData<CrcAdm1025RunData>*>
	v(accessor.access<CrcLocationData<CrcAdm1025RunData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }
    
    if(_select[subRecordType< CrcLocationData<CrcAdm1025ConfigurationData> >()]) {
      std::vector<const CrcLocationData<CrcAdm1025ConfigurationData>*>
       v(accessor.access<CrcLocationData<CrcAdm1025ConfigurationData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

    if(_select[subRecordType< CrcLocationData<CrcAdm1025SlowReadoutData> >()]) {
      std::vector<const CrcLocationData<CrcAdm1025SlowReadoutData>*>
	v(accessor.access<CrcLocationData<CrcAdm1025SlowReadoutData> >());
      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout) << std::endl;
      }
    }

  }

  /*
  template <class Payload> void doPrint(const RcdRecord &r) const {
    if(_select[subRecordType<Payload>()]) {
      SubAccessor accessor(r);
      std::vector<const Payload*> v;
      v=accessor.access<>(); /// DOES NOT COMPILE!!!
      //v=accessor.access();

      for(unsigned i(0);i<v.size();i++) {
	v[i]->print(std::cout,"DOPRINT ") << std::endl;
      }
    }
  }
  */

private:
  unsigned _printLevel;
  bool _selectSubrecords;
  bool _selectType[RcdHeader::endOfRecordTypeEnum];
  bool _select[65536];
};

#endif
