#ifndef EmcReadout_HH
#define EmcReadout_HH

#include <iostream>
#include <fstream>

#include "CrcReadout.hh"


class EmcReadout : public CrcReadout {

public:
  EmcReadout(unsigned b) : CrcReadout(b,0xec) {
  }

  EmcReadout(unsigned b, unsigned char c) : CrcReadout(b,c) {
  }

  virtual ~EmcReadout() {
  }

  virtual bool record(RcdRecord &r) {
    if(doPrint(r.recordType())) {
      std::cout << "EmcReadout::record()" << std::endl;
      r.RcdHeader::print(std::cout," ") << std::endl;
    }
                                                                                                                             
    return CrcReadout::record(r);
  }

  /*
  virtual bool writeFeConfigurationData(RcdRecord &r) {
    SubAccessor extracter(r);
    std::vector<const CrcLocationData<EmcFeConfigurationData>*>
      femc(extracter.extract< CrcLocationData<EmcFeConfigurationData> >());
    
    // First do slot broadcast
    for(unsigned j(0);j<femc.size();j++) {
      if(femc[j]->crateNumber()==_location.crateNumber() && femc[j]->slotBroadcast()) {
	if(_printLevel>2) femc[j]->print(std::cout);

	// Loop over all the CRCs
	for(unsigned i(0);i<=21;i++) {
	  if(_device[i]!=0) {
	    if(femc[j]->crcComponent()==CrcLocation::feBroadcast) {
	      for(unsigned f(0);f<8;f++) {
		assert(_device[i]->writeEmcFeConfigurationData((CrcLocation::CrcComponent)f,*femc[j]->data()));
	      }
	    } else {
	      assert(_device[i]->writeEmcFeConfigurationData(femc[j]->crcComponent(),*femc[j]->data()));
	    }
	  }
	}
      }
    }

    // Next do FE broadcast 
    for(unsigned j(0);j<femc.size();j++) {
      if(femc[j]->crateNumber()==_location.crateNumber() && !femc[j]->slotBroadcast()) {
	assert(femc[j]->slotNumber()<=21);
	
	if(femc[j]->crcComponent()==CrcLocation::feBroadcast) {
	  
	  if(_device[femc[j]->slotNumber()]!=0) {
	    if(_printLevel>2) femc[j]->print(std::cout) << std::endl;
	    for(unsigned f(0);f<8;f++) {
	      assert(_device[femc[j]->slotNumber()]->writeEmcFeConfigurationData((CrcLocation::CrcComponent)f,*femc[j]->data()));
	    }
	  }
	}
      }
    }


    // Finally do individual FE configurations
    for(unsigned j(0);j<femc.size();j++) {
      if(femc[j]->crateNumber()==_location.crateNumber()) {
	if(!femc[j]->slotBroadcast() && femc[j]->crcComponent()!=CrcLocation::feBroadcast) {
	  if(_printLevel>2) femc[j]->print(std::cout);
	  assert(_device[femc[j]->slotNumber()]->writeEmcFeConfigurationData(femc[j]->crcComponent(),*femc[j]->data()));
	}
      }
    }

    return true;
  }

  virtual bool readFeConfigurationData(RcdRecord &r) {
    SubInserter inserter(r);

    for(unsigned i(0);i<=21;i++) {
      if(_device[i]!=0) {
	CrcLocation cl(_location.crateNumber(),_device[i]->slot(),CrcLocation::vme);

	for(unsigned f(0);f<8;f++) {
          if(_config.slotFeEnable(i,f)) {
	    cl.crcComponent((CrcLocation::CrcComponent)f);
	    CrcLocationData<EmcFeConfigurationData>
	      *e(inserter.insert< CrcLocationData<EmcFeConfigurationData> >());
	    e->location(cl);
	    _device[i]->readEmcFeConfigurationData(cl.crcComponent(),*e->data());
	    if(_printLevel>2) e->print(std::cout);
	  }
	} 
      }
    }

    return true;
  }
  */

private:
};

#endif
