#include "TSystem.h"
#include "TCanvas.h"
#include "TH1F.h"

#include "HstCaen767Store.hh"
#include "ShmObject.hh"

void HstCaen767(const unsigned bits=0xffffffff, const unsigned sleepMs=1000) {

  /////////////////////////////////
  const unsigned granularity(10);
  /////////////////////////////////

  // Connect to shared memory  
  ShmObject<HstCaen767Store> _shmHstCaen767Store(HstCaen767Store::shmKey);
  HstCaen767Store *_pShm(_shmHstCaen767Store.payload());
  assert(_pShm!=0);

  // Reset ROOT
  gROOT->Reset();

  UtlPack uBits(bits);

  // Canvas locations and sizes
  const unsigned dx(600),dy(750);
  unsigned cx(10),cy(10);

  // Canvas variables
  TCanvas *glbCanvas;
  TCanvas *tdcCanvas[HstCaen767Store::maximumNumberOfTdcs];
  TCanvas *chnCanvas[HstCaen767Store::maximumNumberOfTdcs]
    [HstCaen767Store::maximumNumberOfChannels];

  std::string nums[10]={"0","1","2","3","4","5","6","7","8","9"};


  // Make the global canvas
  std::string glbLabel("HstCaen767Global");
  glbCanvas=new TCanvas((glbLabel+"Canvas").c_str(),
			glbLabel.c_str(),
			cx,cy,(cx++)+dx,(cy++)+dy);
  
  // Set up global histogram titles
  std::string glbTitle[4];
  glbTitle[0]="Number of subrecords;Number;Events";
  glbTitle[1]="Number of subrecords (errors);Number;Events";
  glbTitle[2]="Subrecords per TDC;Number;Events";
  glbTitle[3]="Subrecords per TDC (errors);Number;Events";

  TH1F *glbHist[4];
  glbHist[0]=new TH1F((glbLabel+"Hist0").c_str(),
		      (_pShm->title()+glbTitle[0]).c_str(),
		      _pShm->_size.numberOfBins(),
		      0,_pShm->_size.numberOfBins());
  glbHist[1]=new TH1F((glbLabel+"Hist1").c_str(),
		      (_pShm->title()+glbTitle[1]).c_str(),
		      _pShm->_size.numberOfBins(),
		      0,_pShm->_size.numberOfBins());
  glbHist[2]=new TH1F((glbLabel+"Hist2").c_str(),
		      (_pShm->title()+glbTitle[2]).c_str(),
		      _pShm->_tdcs.numberOfBins(),
		      0,_pShm->_tdcs.numberOfBins());
  glbHist[3]=new TH1F((glbLabel+"Hist3").c_str(),
		      (_pShm->title()+glbTitle[3]).c_str(),
		      _pShm->_tdcs.numberOfBins(),
		      0,_pShm->_tdcs.numberOfBins());
  
  // Layout the canvas
  glbCanvas->Divide(1,2);
  glbCanvas->cd(1);
  glbHist[0]->Draw();
  glbHist[1]->Draw("same");
  glbHist[1]->SetFillColor(kRed);
  glbCanvas->cd(2);
  glbHist[2]->Draw();
  glbHist[3]->Draw("same");
  glbHist[3]->SetFillColor(kRed);


  std::string tdcTitle[HstCaen767Store::maximumNumberOfTdcs][10];
  TH1F *tdcHist[HstCaen767Store::maximumNumberOfTdcs][10];

  for(unsigned t(0);t<_pShm->_numberOfTdcs;t++) {
    if(t<4 && uBits.byte(t)!=0) {
    
      // Set up global per TDC canvases
      std::ostringstream sout;
      sout << "HstCaen767GlobalTdc" << t;
      std::string tdcLabel(sout.str());
      
      tdcCanvas[t]=new TCanvas((tdcLabel+"HistCanvas").c_str(),
			       tdcLabel.c_str(),
			       cx,cy,(cx++)+dx,(cy++)+dy);
      
      // Set up global per TDC histograms
      tdcTitle[t][0]="Number of subrecords;Number;Events";
      tdcTitle[t][1]="Number of subrecords (errors);Number;Events";
      tdcTitle[t][2]="Number of headers;Number;Events";
      tdcTitle[t][3]="Number of headers (errors);Number;Events";
      tdcTitle[t][4]="Number of eobs;Number;Events";
      tdcTitle[t][5]="Number of eobs (errors);Number;Events";
      tdcTitle[t][6]="Number of invalids;Number;Events";
      tdcTitle[t][7]="Number of invalids (errors);Number;Events";
      tdcTitle[t][8]="Number of words;Number;Events";
      tdcTitle[t][9]="Number of words (errors);Number;Events";
      
      tdcHist[t][0]=new TH1F((tdcLabel+"Hist0").c_str(),
			     (_pShm->title()+tdcTitle[t][0]).c_str(),
			     _pShm->_sizePerTdc[t].numberOfBins(),
			     0,_pShm->_sizePerTdc[t].numberOfBins());
      tdcHist[t][1]=new TH1F((tdcLabel+"Hist1").c_str(),
			     (_pShm->title()+tdcTitle[t][1]).c_str(),
			     _pShm->_sizePerTdc[t].numberOfBins(),
			     0,_pShm->_sizePerTdc[t].numberOfBins());
      tdcHist[t][2]=new TH1F((tdcLabel+"Hist2").c_str(),
			     (_pShm->title()+tdcTitle[t][2]).c_str(),
			     _pShm->_labels[t][0].numberOfBins(),
			     0,_pShm->_labels[t][0].numberOfBins());
      tdcHist[t][3]=new TH1F((tdcLabel+"Hist3").c_str(),
			     (_pShm->title()+tdcTitle[t][3]).c_str(),
			     _pShm->_labels[t][0].numberOfBins(),
			     0,_pShm->_labels[t][0].numberOfBins());
      tdcHist[t][4]=new TH1F((tdcLabel+"Hist4").c_str(),
			     (_pShm->title()+tdcTitle[t][4]).c_str(),
			     _pShm->_labels[t][1].numberOfBins(),
			     0,_pShm->_labels[t][1].numberOfBins());
      tdcHist[t][5]=new TH1F((tdcLabel+"Hist5").c_str(),
			     (_pShm->title()+tdcTitle[t][5]).c_str(),
			     _pShm->_labels[t][1].numberOfBins(),
			     0,_pShm->_labels[t][1].numberOfBins());
      tdcHist[t][6]=new TH1F((tdcLabel+"Hist6").c_str(),
			   (_pShm->title()+tdcTitle[t][6]).c_str(),
			     _pShm->_labels[t][2].numberOfBins(),
			     0,_pShm->_labels[t][2].numberOfBins());
      tdcHist[t][7]=new TH1F((tdcLabel+"Hist7").c_str(),
			     (_pShm->title()+tdcTitle[t][7]).c_str(),
			     _pShm->_labels[t][2].numberOfBins(),
			     0,_pShm->_labels[t][2].numberOfBins());
      tdcHist[t][8]=new TH1F((tdcLabel+"Hist8").c_str(),
			     (_pShm->title()+tdcTitle[t][8]).c_str(),
			   _pShm->_numberOfWords[t].numberOfBins(),
			     0,_pShm->_numberOfWords[t].numberOfBins());
      tdcHist[t][9]=new TH1F((tdcLabel+"Hist9").c_str(),
			   (_pShm->title()+tdcTitle[t][9]).c_str(),
			     _pShm->_numberOfWords[t].numberOfBins(),
			     0,_pShm->_numberOfWords[t].numberOfBins());

      // Layout the canvas
      tdcCanvas[t]->Divide(1,3);
      
      tdcCanvas[t]->cd(1);
      gPad->Divide(2,1);
      
      tdcCanvas[t]->cd(1);
      gPad->cd(1);
      tdcHist[t][0]->Draw();
      tdcHist[t][1]->Draw("same");
      tdcHist[t][1]->SetFillColor(kRed);
      
      tdcCanvas[t]->cd(1);
      gPad->cd(2);
      tdcHist[t][2]->Draw();
      tdcHist[t][3]->Draw("same");
      tdcHist[t][3]->SetFillColor(kRed);
      
      tdcCanvas[t]->cd(2);
      gPad->Divide(2,1);
      
      tdcCanvas[t]->cd(2);
      gPad->cd(1);
      tdcHist[t][4]->Draw();
      tdcHist[t][5]->Draw("same");
      tdcHist[t][5]->SetFillColor(kRed);
      
      tdcCanvas[t]->cd(2);
      gPad->cd(2);
      tdcHist[t][6]->Draw();
      tdcHist[t][7]->Draw("same");
      tdcHist[t][7]->SetFillColor(kRed);
      
      tdcCanvas[t]->cd(3);
      tdcHist[t][8]->Draw();
      tdcHist[t][9]->Draw("same");
      tdcHist[t][9]->SetFillColor(kRed);
      

    // Now do channel stuff
    
//    const UtlPack uBits(bits);
    
    std::string chnTitle[HstCaen767Store::maximumNumberOfTdcs][HstCaen767Store::maximumNumberOfChannels][6];
    TH1F *chnHist[HstCaen767Store::maximumNumberOfTdcs][HstCaen767Store::maximumNumberOfChannels][6];

    for(unsigned c(0);c<_pShm->maximumNumberOfChannels;c++) {
      if(t<4 && c<8 && uBits.bit(8*t+c)) {

	std::ostringstream sout;
	sout << "HstCaen767Tdc" << t << "Channel" 
	     << std::setfill('0') << c << std::setfill(' ');
	std::string chnLabel(sout.str());

	chnCanvas[t][c]=new TCanvas((chnLabel+"HistCanvas").c_str(),
				    chnLabel.c_str(),
				    cx,cy,(cx++)+dx,(cy++)+dy);

	// Set up per TDC histograms
	chnTitle[t][c][0]="Number of leading;Number;Events";
	chnTitle[t][c][1]="Number of leading (errors);Number;Events";
	chnTitle[t][c][2]="Number of falling;Number;Events";
	chnTitle[t][c][3]="Number of falling (errors);Number;Events";
	chnTitle[t][c][4]="Leading edge time;Time (TDC units = 0.75ns);Events";
	chnTitle[t][c][5]="Falling edge time;Time (TDC units = 0.75ns);Events";

	/*	
	std::ostringstream sout[6];
	
	sout[0] << "Caen767 Channel " << std::setw(2) << i
		<< " number of leading edge words;Number;Events";
	sout[1] << "Caen767 Channel " << std::setw(2) << i
		<< " number of leading edge words (errors);Number;Events";
	sout[2] << "Caen767 Channel " << std::setw(2) << i
		<< " number of falling edge words;Number;Events";
	sout[3] << "Caen767 Channel " << std::setw(2) << i
		<< " number of falling edge words (errors);Number;Events";
	sout[4] << "Caen767 Channel " << std::setw(2) << i
		<< " leading edge hits;Time (TDC units = 0.75 ns);Events";
	sout[5] << "Caen767 Channel " << std::setw(2) << i
		<< " falling edge hits;Time (TDC units = 0.75 ns);Events";
	*/

	for(unsigned i(0)i<6;i++) {
	  unsigned bins;
	  if(i==0) bins=_pShm->_numberOfWordsPerChannel[t][c][0].numberOfBins();
	  if(i==1) bins=_pShm->_numberOfWordsPerChannel[t][c][0].numberOfBins();
	  if(i==2) bins=_pShm->_numberOfWordsPerChannel[t][c][1].numberOfBins();
	  if(i==3) bins=_pShm->_numberOfWordsPerChannel[t][c][1].numberOfBins();
	  if(i==4) bins=_pShm->_tdcValues[t][c][0].numberOfBins();
	  if(i==5) bins=_pShm->_tdcValues[t][c][1].numberOfBins();

	  chnHist[t][c][i]=new TH1F((chnLabel+"Hist"+nums[i]).c_str(),
				  (_pShm->title()+chnTitle[t][c][i]).c_str(),
				    bins,0,bins);
	}

	chnCanvas[t][c]->Divide(1,3);
	chnCanvas[t][c]->cd(1);
	gPad->Divide(2,1);

	chnCanvas[t][c]->cd(1);
	gPad->cd(1);
	chnHist[t][c][0]->Draw();
	chnHist[t][c][1]->Draw("same");
	chnHist[t][c][1]->SetFillColor(kRed);
      
	chnCanvas[t][c]->cd(1);
	gPad->cd(2);
	chnHist[t][c][2]->Draw();
	chnHist[t][c][3]->Draw("same");
	chnHist[t][c][3]->SetFillColor(kRed);

	chnCanvas[t][c]->cd(2);
	chnHist[t][c][4]->Draw();

	chnCanvas[t][c]->cd(3);
	chnHist[t][c][5]->Draw();
      }
    }
  }


    /*

  TH1F *hstCaen767[16][6];

	for(unsigned c(0);c<_pShm->maximumNumberOfChannels;c++) {
  for(unsigned i(0);i<16;i++) {
    if(uBits.bit(i)) {
      hstCaen767[i][0]=new TH1F(hTitle[i][0].c_str(),(_pShm->title()+hTitle[i][0]).c_str(),
			    20,0,20);
      hstCaen767[i][1]=new TH1F(hTitle[i][1].c_str(),(_pShm->title()+hTitle[i][1]).c_str(),
			    20,0,20);
      hstCaen767[i][2]=new TH1F(hTitle[i][2].c_str(),(_pShm->title()+hTitle[i][2]).c_str(),
			    20,0,20);
      hstCaen767[i][3]=new TH1F(hTitle[i][3].c_str(),(_pShm->title()+hTitle[i][3]).c_str(),
			    20,0,20);
      hstCaen767[i][4]=new TH1F(hTitle[i][4].c_str(),(_pShm->title()+hTitle[i][4]).c_str(),
			    (10000+granularity-1)/granularity,0,10000);
      hstCaen767[i][5]=new TH1F(hTitle[i][5].c_str(),(_pShm->title()+hTitle[i][5]).c_str(),
			    (10000+granularity-1)/granularity,0,10000);


      chnChannel[i]->cd(1);
      gPad->cd(1);
      hstCaen767[i][0]->SetOptStat(111111);
      hstCaen767[i][0]->Draw();
      hstCaen767[i][1]->Draw("same");
      hstCaen767[i][1]->SetFillColor(kRed);
      
      //      chnChannel[i]->cd(4);
      chnChannel[i]->cd(1);
      gPad->cd(2);
      hstCaen767[i][2]->Draw();
      hstCaen767[i][3]->Draw("same");
      hstCaen767[i][3]->SetFillColor(kRed);
      
      chnChannel[i]->cd(2);
      hstCaen767[i][4]->Draw();
      
      chnChannel[i]->cd(3);
      hstCaen767[i][5]->Draw();
    }

  */




  }











  const unsigned sMs(5);
  HstFlags::Level refresh(HstFlags::event);
  //if(acqRefresh) refresh=HstFlags::acquisition;

  while(!gSystem->ProcessEvents() && _pShm->_inJob) {

    //for(unsigned i(0);i<sleepMs && (_pShm->_inAcquisition || !_pShm->_validEvent);i+=sMs) {
    for(unsigned i(0);i<sleepMs && !_pShm->ready(refresh);i+=sMs) {
      std::cout << "NOT FINISHED" << std::endl;
      gSystem->Sleep(sMs);
    }

    if(_pShm->ready(refresh)) {

      // Global plots

      glbHist[0]->SetTitle((_pShm->title()+glbTitle[0]).c_str());
      glbHist[1]->SetTitle((_pShm->title()+glbTitle[1]).c_str());

      for(unsigned i(0);i<_pShm->_size.numberOfBins();i++) {
	glbHist[0]->SetBinContent(i+1,_pShm->_size.contents(i));
	if(i>2) {
	  glbHist[1]->SetBinContent(i+1,_pShm->_size.contents(i));
	} else {
	  glbHist[1]->SetBinContent(i+1,0);
	}
      }

      glbHist[0]->SetBinContent(0,_pShm->_tdcs.underflow());
      glbHist[0]->SetBinContent(_pShm->_tdcs.numberOfBins()+1,
				  _pShm->_tdcs.overflow());
      glbHist[0]->SetEntries(_pShm->_tdcs.entries());



      glbHist[2]->SetTitle((_pShm->title()+glbTitle[2]).c_str());
      glbHist[3]->SetTitle((_pShm->title()+glbTitle[3]).c_str());

      for(unsigned i(0);i<_pShm->_tdcs.numberOfBins();i++) {
	glbHist[2]->SetBinContent(i+1,_pShm->_tdcs.contents(i));
	if(i>=_pShm->maximumNumberOfTdcs) {
	  glbHist[3]->SetBinContent(i+1,_pShm->_tdcs.contents(i));
	} else {
	  glbHist[3]->SetBinContent(i+1,0);
	}
      }

      glbHist[2]->SetBinContent(0,_pShm->_tdcs.underflow());
      glbHist[2]->SetBinContent(_pShm->_tdcs.numberOfBins()+1,
				  _pShm->_tdcs.overflow());
      glbHist[2]->SetEntries(_pShm->_tdcs.entries());


      // Do number of subrecords plot

      for(unsigned t(0);t<_pShm->_numberOfTdcs;t++) {
	if(t<4 && uBits.byte(t)!=0) {

	  tdcHist[t][0]->SetTitle((_pShm->title()+tdcTitle[t][0]).c_str());
	  tdcHist[t][1]->SetTitle((_pShm->title()+tdcTitle[t][1]).c_str());
	  
	  //_pShm->_sizePerTdc[t].print(std::cout," PER TDC ");
	  for(unsigned i(0);i<_pShm->_sizePerTdc[t].numberOfBins();i++) {
	    tdcHist[t][0]->SetBinContent(i+1,_pShm->_sizePerTdc[t].contents(i));
	    if(i>1) {
	      tdcHist[t][1]->SetBinContent(i+1,_pShm->_sizePerTdc[t].contents(i));
	    } else {
	      tdcHist[t][1]->SetBinContent(i+1,0);
	    }
	  }
	  
	  tdcHist[t][0]->SetBinContent(0,_pShm->_sizePerTdc[t].underflow());
	  tdcHist[t][0]->SetBinContent(_pShm->_sizePerTdc[t].numberOfBins()+1,
				       _pShm->_sizePerTdc[t].overflow());
	  tdcHist[t][0]->SetEntries(_pShm->_sizePerTdc[t].entries());
	  
	  
	  // Do labels plots
	  for(unsigned l(0);l<3;l++) {	
	    //_pShm->_labels[t][l].print(std::cout," LABEL ");
	    tdcHist[t][2+2*l]->SetTitle((_pShm->title()+tdcTitle[t][2+2*l]).c_str());
	    tdcHist[t][3+2*l]->SetTitle((_pShm->title()+tdcTitle[t][3+2*l]).c_str());
	    
	    for(unsigned i(0);i<_pShm->_labels[t][l].numberOfBins();i++) {
	      tdcHist[t][2+2*l]->SetBinContent(i+1,_pShm->_labels[t][l].contents(i));
	      if((l<2 && i>1) || (l==2 && i>0)) {
		tdcHist[t][3+2*l]->SetBinContent(i+1,_pShm->_labels[t][l].contents(i));
	      } else {
		tdcHist[t][3+2*l]->SetBinContent(i+1,0);
	      }
	    }
	    
	    tdcHist[t][2+2*l]->SetBinContent(0,_pShm->_labels[t][l].underflow());
	    tdcHist[t][2+2*l]->SetBinContent(_pShm->_labels[t][l].numberOfBins()+1,
					     _pShm->_labels[t][l].overflow());
	    tdcHist[t][2+2*l]->SetEntries(_pShm->_labels[t][l].entries());
	  }
	  
	  
	  tdcHist[t][8]->SetTitle((_pShm->title()+tdcTitle[t][8]).c_str());
	  tdcHist[t][9]->SetTitle((_pShm->title()+tdcTitle[t][9]).c_str());
	  
	  for(unsigned i(0);i<_pShm->_numberOfWords[t].numberOfBins();i++) {
	    tdcHist[t][8]->SetBinContent(i+1,_pShm->_numberOfWords[t].contents(i));
	    if(i>=100) {
	      tdcHist[t][9]->SetBinContent(i+1,_pShm->_numberOfWords[t].contents(i));
	    } else {
	      tdcHist[t][9]->SetBinContent(i+1,0);
	    }
	  }
	  
	  tdcHist[t][8]->SetBinContent(0,_pShm->_numberOfWords[t].underflow());
	  tdcHist[t][8]->SetBinContent(_pShm->_numberOfWords[t].numberOfBins()+1,
				       _pShm->_numberOfWords[t].overflow());
	  tdcHist[t][8]->SetEntries(_pShm->_numberOfWords[t].entries());
	
	

	  for(unsigned c(0);c<_pShm->maximumNumberOfChannels;c++) {
	    if(t<4 && c<8 && uBits.bit(8*t+c)) {
	      /*

	      // Do number of words plot
	      
	      hstCaen767[i][0]->SetTitle((_pShm->title()+hTitle[i][0]).c_str());
	      hstCaen767[i][1]->SetTitle((_pShm->title()+hTitle[i][1]).c_str());
	      hstCaen767[i][2]->SetTitle((_pShm->title()+hTitle[i][2]).c_str());
	      hstCaen767[i][3]->SetTitle((_pShm->title()+hTitle[i][3]).c_str());
	      hstCaen767[i][4]->SetTitle((_pShm->title()+hTitle[i][4]).c_str());
	      hstCaen767[i][5]->SetTitle((_pShm->title()+hTitle[i][5]).c_str());
	      
	      for(unsigned j(0);j<20;j++) {
	      if(i<=16) {
	      hstCaen767[i][0]->SetBinContent(j+1,_pShm->_numberOfWordsPerChannel[i][0][j]);
	      hstCaen767[i][1]->SetBinContent(j+1,0);
	      hstCaen767[i][2]->SetBinContent(j+1,_pShm->_numberOfWordsPerChannel[i][1][j]);
	      hstCaen767[i][3]->SetBinContent(j+1,0);
	      } else {
	      hstCaen767[i][0]->SetBinContent(j+1,0);
	      hstCaen767[i][1]->SetBinContent(j+1,_pShm->_numberOfWordsPerChannel[i][0][j]);
	      hstCaen767[i][2]->SetBinContent(j+1,0);
	      hstCaen767[i][3]->SetBinContent(j+1,_pShm->_numberOfWordsPerChannel[i][1][j]);
	      }
	      }
	      
	      for(unsigned j(0);j<(10000+granularity-1)/granularity;j++) {
	      unsigned suml(0),sumf(0);
	      for(unsigned k(granularity*j);k<granularity*(j+1);k++) {
	      suml+=_pShm->_tdc[i][0][k];
	      sumf+=_pShm->_tdc[i][1][k];
	      }
	      
	      hstCaen767[i][4]->SetBinContent(j+1,suml);
	      hstCaen767[i][5]->SetBinContent(j+1,sumf);

	      */
	    }
	  }
	}
      }
    
      
      glbCanvas->cd(1);
      gPad->Modified();
      glbCanvas->cd(2);
      gPad->Modified();

      for(unsigned t(0);t<_pShm->_numberOfTdcs;t++) {
	if(t<4 && uBits.byte(t)!=0) {
	  tdcCanvas[t]->cd(1);
	  gPad->cd(1);
	  gPad->Modified();
	  tdcCanvas[t]->cd(1);
	  gPad->cd(2);
	  gPad->Modified();
	  tdcCanvas[t]->cd(2);
	  gPad->cd(1);
	  gPad->Modified();
	  tdcCanvas[t]->cd(2);
	  gPad->cd(2);
	  gPad->Modified();
	  tdcCanvas[t]->cd(3);
	  gPad->Modified();
	
	  for(unsigned c(0);c<_pShm->maximumNumberOfChannels;c++) {
	    if(t<4 && c<8 && uBits.bit(8*t+c)) {
	      chnCanvas[t][c]->cd(1);
	      gPad->cd(1);
	      gPad->Modified();
	      chnCanvas[t][c]->cd(1);
	      gPad->cd(2);
	      gPad->Modified();
	      chnCanvas[t][c]->cd(2);
	      gPad->Modified();
	      chnCanvas[t][c]->cd(3);
	      gPad->Modified();
	    }
	  }
	}
      }

      // Finally do all the updates
      glbCanvas->Update();

      for(unsigned t(0);t<_pShm->_numberOfTdcs;t++) {
	if(t<4 && uBits.byte(t)!=0) {
	  tdcCanvas[t]->Update();

	  for(unsigned c(0);c<_pShm->maximumNumberOfChannels;c++) {
	    if(t<4 && c<8 && uBits.bit(8*t+c)) {
	      chnCanvas[t][c]->Update();
	    } 
	  } 
	}
      }
    }

    gSystem->Sleep(sleepMs);
  }
}
