#include "TMapFile.h"
#include "TSystem.h"
#include "TCanvas.h"
#include "TH1F.h"

void HstRecord(const unsigned bits=0xf, const unsigned sleepMs=1000) {

  if((bits&0xf)==0) return;

  gROOT->Reset();

  // Open the memory mapped file in "READ" (default) mode.
  TMapFile* mfile = TMapFile::Create("HstGeneric.map");

  // Print status of mapped file
  mfile->Print();

  // Create four canvases, each with three pads
  TCanvas *hstRecordCanvas[4];

  for(unsigned i=0;i<4;i++) {
    if((bits&(1<<i))!=0) {
      std::ostringstream label,title;
      label << "HstRecordCanvas" << i;
      title << "HstRecord" << i;
      std::string cLabel(label.str());
      std::string cTitle(title.str());
      
      hstRecordCanvas[i]=new TCanvas(cLabel.c_str(),cTitle.c_str(),
				     10+10*i,10+10*i,610+10*i,760+10*i);
      hstRecordCanvas[i]->Divide(1,3);
    }
  }
  
  // Create titles in shared memory
  TH1F *hstRecord[4][7];
  std::string hTitle[4][7];

  for(unsigned i=0;i<4;i++) {
    if((bits&(1<<i))!=0) {
      std::string period;
      if(i==0) period="Job";
      if(i==1) period="Run";
      if(i==2) period="Cfg";
      if(i==3) period="Acq";
      
      for(unsigned j(0);j<7;j++) {
	std::string type;
	if(j==0) type="RSize";
	if(j==1) type="TSize";
	if(j==2) type="ESize";
	if(j==3) type="RRate";
	if(j==4) type="TRate";
	if(j==5) type="ERate";
	if(j==6) type="DRate";
	
	std::ostringstream title;
	title << "HstRecord" << period << type;
	hTitle[i][j]=title.str();
	
	// Get pointers and check histograms exist
	hstRecord[i][j]=(TH1F*)mfile->Get(hTitle[i][j].c_str());
	if(hstRecord[i][j]==0) {
	  mfile->ls();    
	  std::cout << "Histogram " << hTitle[i][j] << " not found" << std::endl;
	  return;
	}	
      }
    }
  }

  // Make local versions of the histograms
  /*
  TH1F *localHstRecord[4][7];
  for(unsigned i=0;i<4;i++) {
    for(unsigned j(0);j<7;j++) {
      localHstRecord[i][j]=new TH1F(*hstRecord[i][j]);
    }

    // Set up display; first record sizes
    hstRecordCanvas[i]->cd(1);
    localHstRecord[i][0]->Draw();
    localHstRecord[i][1]->SetFillColor(kBlue);
    localHstRecord[i][1]->Draw("same");
    localHstRecord[i][2]->SetFillColor(kRed);
    localHstRecord[i][2]->Draw("same");

    // Next record rates
    hstRecordCanvas[i]->cd(2);
    localHstRecord[i][3]->Draw();
    localHstRecord[i][4]->SetFillColor(kBlue);
    localHstRecord[i][4]->Draw("same");
    localHstRecord[i][5]->SetFillColor(kRed);
    localHstRecord[i][5]->Draw("same");

    // Finally data rates
    hstRecordCanvas[i]->cd(3);
    localHstRecord[i][6]->Draw();
  }  
  */

  // Loop displaying the histograms; use Ctrl^C to break out of loop
  while(!gSystem->ProcessEvents()) {
    for(unsigned i=0;i<4;i++) {
      if((bits&(1<<i))!=0) {
	hstRecordCanvas[i]->Modified();
	hstRecordCanvas[i]->Update();
      }
    }
    gSystem->Sleep(sleepMs);
    
    for(unsigned i=0;i<4;i++) {
      if((bits&(1<<i))!=0) {
	for(unsigned j(0);j<7;j++) {
	  hstRecord[i][j]=(TH1F*)mfile->Get(hTitle[i][j].c_str(),hstRecord[i][j]);
	}
	
      //	if(hstRecord[i][j]!=0) {

	// Set up display; first record sizes
	hstRecordCanvas[i]->cd(1);
	hstRecord[i][0]->Draw();
	hstRecord[i][1]->SetFillColor(kBlue);
	hstRecord[i][1]->Draw("same");
	hstRecord[i][2]->SetFillColor(kRed);
	hstRecord[i][2]->Draw("same");
	
	// Next record rates
	hstRecordCanvas[i]->cd(2);
	hstRecord[i][3]->Draw();
	hstRecord[i][4]->SetFillColor(kBlue);
	hstRecord[i][4]->Draw("same");
	hstRecord[i][5]->SetFillColor(kRed);
	hstRecord[i][5]->Draw("same");
	
	// Finally data rates
	hstRecordCanvas[i]->cd(3);
	hstRecord[i][6]->Draw();
	
	
	//std::cout << "Updating " << hTitle[i][j] << std::endl;
	//*localHstRecord[i][j]=*hstRecord[i][j];
	/*
	  localHstRecord[i][j]->SetEntries(hstRecord[i][j]->GetEntries());
	  for(int k(0);k<=1+hstRecord[i][j]->GetNbinsX();k++) {
	  localHstRecord[i][j]->SetBinContent(k,hstRecord[i][j]->GetBinContent(k));
	  //localHstRecord[i][j]->SetBinError(k,hstRecord[i][j]->GetBinError(k));
	  }
	*/
      }
    }
  }
}
