#include "TSystem.h"
#include "TCanvas.h"
#include "TH1F.h"

#include "HstRecordStore.hh"
#include "ShmObject.hh"

void HstRecord(const unsigned bits=0xf, const unsigned sleepMs=1000) {

  /////////////////////////////////
  const unsigned granularity(5);
  /////////////////////////////////

  // Connect to shared memory  
  ShmObject<HstRecordStore> _shmHstRecordStore(HstRecordStore::shmKey);
  HstRecordStore *_pShm(_shmHstRecordStore.payload());
  assert(_pShm!=0);

  gROOT->Reset();

  const UtlPack uBits(bits);

  std::string tags[4];
  tags[0]="Job";
  tags[1]="Run";
  tags[2]="Cfg";
  tags[3]="Acq";
  
  TCanvas *cvsChannel[4];
  std::string hCanvas[4];

  for(unsigned i(0);i<4;i++) {
    if(uBits.bit(i)) {
      hCanvas[i]=std::string("HstRecord")+tags[i];
      cvsChannel[i]=new TCanvas((hCanvas[i]+"Canvas").c_str(),
			    hCanvas[i].c_str(),
			    10+10*i,10+10*i,610+10*i,760+10*i);
      cvsChannel[i]->Divide(1,2);
    }
  }

  TH1F *hstRecord[4][6];

  std::string hTitle[4][6];
  std::string hLabel[4][6];

  for(unsigned i(0);i<4;i++) {
    if(uBits.bit(i)) {
      hTitle[i][0]=tags[i]+" record rate;Time (sec);Rate (Hz)";
      hTitle[i][1]=tags[i]+" event rate;Time (sec);Rate (Hz)";
      hTitle[i][2]=tags[i]+" trigger rate;Time (sec);Rate (Hz)";
      hTitle[i][3]=tags[i]+" record data rate;Time (sec);Data rate (MBytes/s)";
      hTitle[i][4]=tags[i]+" event data rate;Time (sec);Data rate (MBytes/s)";
      hTitle[i][5]=tags[i]+" trigger data rate;Time (sec);Data rate (MBytes/s)";
      hLabel[i][0]=tags[i]+"RecordRate";
      hLabel[i][1]=tags[i]+"EventRate";
      hLabel[i][2]=tags[i]+"TriggerRate";
      hLabel[i][3]=tags[i]+"RecordDataRate";
      hLabel[i][4]=tags[i]+"EventDataRate";
      hLabel[i][5]=tags[i]+"TriggerDataRate";


      for(unsigned j(0);j<6;j++) {
	hstRecord[i][j]=new TH1F(hLabel[i][j].c_str(),
				 (_pShm->title()+hTitle[i][j]).c_str(),
				 (1000+granularity-1)/granularity,
				 0.0,_pShm->_rateRange[i]);
      }

      cvsChannel[i]->cd(1);
      hstRecord[i][0]->Draw();
      hstRecord[i][2]->Draw("same");
      hstRecord[i][2]->SetFillColor(kGreen);
      hstRecord[i][1]->Draw("same");
      hstRecord[i][1]->SetFillColor(kBlue);
      
      cvsChannel[i]->cd(2);
      hstRecord[i][3]->Draw();
      hstRecord[i][5]->Draw("same");
      hstRecord[i][5]->SetFillColor(kGreen);
      hstRecord[i][4]->Draw("same");
      hstRecord[i][4]->SetFillColor(kBlue);
    }
  }

  const unsigned sMs(5);
  HstFlags::Level refresh(HstFlags::event);
  //if(acqRefresh) refresh=HstFlags::acquisition;

  while(!gSystem->ProcessEvents() && _pShm->_inJob) {

    //for(unsigned i(0);i<sleepMs && (_pShm->_inAcquisition || !_pShm->_validEvent);i+=sMs) {
    for(unsigned i(0);i<sleepMs && !_pShm->ready(refresh);i+=sMs) {
      std::cout << "NOT FINISHED" << std::endl;
      gSystem->Sleep(sMs);
    }

    //if(_pShm->ready(refresh)) {
    if(true) {

      // Do number of words plot
      for(unsigned i(0);i<4;i++) {
	if(uBits.bit(i)) {
	  for(unsigned m(0);m<6;m++) {
	    hstRecord[i][m]->SetTitle((_pShm->title()+hTitle[i][m]).c_str());
	    hstRecord[i][m]->SetBins((1000+granularity-1)/granularity,
				     0,_pShm->_rateRange[i]);
	  }
	  
	  for(unsigned j(0);j<(1000+granularity-1)/granularity;j++) {
	    unsigned sum[6];
	    for(unsigned m(0);m<6;m++) sum[m]=0;

	    for(unsigned k(granularity*j);k<granularity*(j+1);k++) {
	      for(unsigned r(0);r<RcdHeader::endOfRecordTypeEnum;r++) {
		sum[0]+=_pShm->_rate[i][r][k];
		if(r==RcdHeader::event)
		  sum[1]+=_pShm->_rate[i][r][k];
		if(r==RcdHeader::event || r==RcdHeader::trigger)
		  sum[2]+=_pShm->_rate[i][r][k];

		sum[3]+=_pShm->_data[i][r][k];
		if(r==RcdHeader::event)
		  sum[4]+=_pShm->_data[i][r][k];
		if(r==RcdHeader::event || r==RcdHeader::trigger)
		  sum[5]+=_pShm->_data[i][r][k];
	      }
	    }
	    
	    for(unsigned m(0);m<3;m++) {
	      hstRecord[i][m]->SetBinContent(j+1,1000*sum[m]/(granularity*_pShm->_rateRange[i]));
	    }
	    for(unsigned m(3);m<6;m++) {
	      hstRecord[i][m]->SetBinContent(j+1,1000*sum[m]/(1024*1024*granularity*_pShm->_rateRange[i]));
	    }
	  }
	}
      }

      for(unsigned i(0);i<4;i++) {
	if(uBits.bit(i)) {
	  cvsChannel[i]->cd(1);
	  gPad->Modified();
	  cvsChannel[i]->cd(2);
	  gPad->Modified();
	}    
      }

      for(unsigned i(0);i<4;i++) {
	if(uBits.bit(i)) {
	  cvsChannel[i]->Update();
	}    
      }    
    }

    gSystem->Sleep(sleepMs);
  }
}
