#define HST_MAP

#include <iostream>
#include <fstream>
#include <sstream>

// dual/inc/utl
#include "UtlArguments.hh"

// dual/inc/rcd
#include "RcdArena.hh"
#include "RcdReaderAsc.hh"
#include "RcdReaderBin.hh"
#include "RunReader.hh"

// dual/inc/chk
#include "FixEmc.hh"
#include "FixAhc.hh"
#include "ChkCount.hh"
#include "HstGeneric.hh"
//#include "HstGeneOff.hh"

using namespace std;


int main(int argc, const char **argv) {
  UtlArguments argh(argc,argv);

  const bool useReadAsc(argh.option('a',"Ascii input file"));
  const bool slwRead(argh.option('s',"Slow data input file"));
  const unsigned printLevel(argh.optionArgument('p',0,"Print level"));
  const unsigned numberOfRecords(argh.optionArgument('r',0xffffffff,
						     "Number of records"));
  const unsigned runNumber(argh.lastArgument(999999));

  if(argh.help()) return 0;

  if(useReadAsc) cout << "Ascii input file selected" << endl;
  else           cout << "Binary input file selected" << endl;
  if(!slwRead) cout << "Normal data file selected" << endl;
  else        cout << "Slow data file selected" << endl;
  cout << "Print level set to " << printLevel << endl;
  cout << "Number of records set to " << numberOfRecords << endl;
  cout << "Run number set to " << runNumber << endl;
  cout << endl;

#ifdef OLD_READER
  RcdReader *reader(0);
  if(useReadAsc) reader=new RcdReaderAsc();
  else           reader=new RcdReaderBin();
  
  ostringstream sout;
  sout << runNumber;
  if(slwRead) {
    assert(reader->open(std::string("data/slw/Slw")+sout.str()));
  } else {
    if(runNumber<100000) assert(reader->open(std::string("data/dat/Run0")+sout.str()));
    else                 assert(reader->open(std::string("data/dat/Run" )+sout.str()));
  }

  if(slwRead) assert(reader->open(std::string("data/slw/Slw")+sout.str()));
  else        assert(reader->open(std::string("data/run/Run")+sout.str()));

#else
  assert(!slwRead);
  RunReader theReader;
  RunReader *reader(&theReader);
  assert(reader->open(runNumber,useReadAsc));
#endif

  FixEmc fe;
  FixAhc fa;
  ChkCount hn;
  hn.printLevel(printLevel);
  HstGeneric hp;
  hp.ignorRunType(true);
  hp.updatePeriod(10);

  RcdArena arena;
  unsigned iRecords(0);
  //while(true) {
    while(reader->read(arena) && iRecords<numberOfRecords) {
      iRecords++;
      //assert(fe.fix(arena));
      //assert(fa.fix(arena));
      assert(hn.record(arena));
      assert(hp.record(arena));
    }
    
    assert(reader->close());
    //}
    
    arena.initialise(RcdHeader::shutDown);
    //assert(fe.fix(arena));
    //assert(fa.fix(arena));
    assert(hn.record(arena));
    assert(hp.record(arena));

    return 0;
}
