#include "runnerDefine.icc"

#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <iostream>

#include "UtlArguments.hh"
#include "RcdArena.hh"
#include "RcdIoSkt.hh"
#include "HstGeneric.hh"
#include "RunLock.hh"

using namespace std;

int main(int argc, const char **argv) {

  unsigned eTime(CALICE_DAQ_TIME);
  cout << argv[0] << " compiled at " << ctime((const time_t*)&eTime);
  
#ifndef HST_SKT
  std::cout << argv[0] << " not compiled for use; exiting" << std::endl;

#else

  UtlArguments argh(argc,argv);
  
  const unsigned port(argh.optionArgument('p',1127,"Port"));
  
  if(argh.help()) return 0;
  
  cout << "Port set to " << port << endl;
  
  RunLock lock(argv[0]);

  RcdIoSkt s;
  HstGeneric c;
  c.printLevel(6);

  RcdArena r;
  r.initialise(RcdHeader::startUp);
  
  assert(s.open(port));
  while(r.recordType()!=RcdHeader::shutDown) {
    
    // Read next record from socket
    assert(s.read(r));

    /*    
    // Check for runStart record
    if(r.recordType()==RcdHeader::runStart) {

      // Access the DaqRunStart to get print level
      SubAccessor accessor(r);
      std::vector<const DaqRunStart*> v(accessor.extract<DaqRunStart>());
      if(v.size()>0)  c.printLevel(v[0]->runType().printLevel());
    }
    */

    // Process record
    assert(c.record(r));
  }

  assert(s.close());

#endif

  return 0;
}
