#ifndef AhcVfeConfigurationData_HH
#define AhcVfeConfigurationData_HH

#include <string>
#include <iostream>

#include "AhcVfeControl.hh"
#include "AhcVfeShiftRegister.hh"

class AhcFeConfigurationDataV0;


class AhcVfeConfigurationData {

public:
  enum {
    versionNumber=1
  };

  AhcVfeConfigurationData();
  AhcVfeConfigurationData(const AhcFeConfigurationDataV0 &a);

  UtlPack verificationData() const;
  void    verificationData(UtlPack v);

  AhcVfeShiftRegister shiftRegister(unsigned hab) const;
  void                shiftRegister(unsigned hab, AhcVfeShiftRegister s);

  bool operator!=(const AhcVfeConfigurationData &c);
  bool operator==(const AhcVfeConfigurationData &c);

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  UtlPack _verificationData;
  AhcVfeShiftRegister _shiftRegister[12];
};


#ifdef CALICE_DAQ_ICC

#include "AhcFeConfigurationDataV0.hh"


AhcVfeConfigurationData::AhcVfeConfigurationData() : _verificationData(0xaaaa5555) {
}

AhcVfeConfigurationData::AhcVfeConfigurationData(const AhcFeConfigurationDataV0 &a) {
  _verificationData=0xffffffff;
  for(unsigned i(0);i<12;i++) {
    shiftRegister(i,a.shiftRegister(i));
  }
}

UtlPack AhcVfeConfigurationData::verificationData() const {
  return _verificationData;
}
 
void AhcVfeConfigurationData::verificationData(UtlPack v) {
  _verificationData=v;
}
 
AhcVfeShiftRegister AhcVfeConfigurationData::shiftRegister(unsigned hab) const {
  assert(hab<12);
  return _shiftRegister[hab];
}

void AhcVfeConfigurationData::shiftRegister(unsigned hab, AhcVfeShiftRegister s) {
  assert(hab<12);
  _shiftRegister[hab]=s;
}

bool AhcVfeConfigurationData::operator!=(const AhcVfeConfigurationData &c) {
  unsigned *a((unsigned*)this);
  unsigned *b((unsigned*)&c);
  for(unsigned i(0);i<sizeof(AhcVfeConfigurationData)/4;i++) {
    if(a[i]!=b[i]) return true;
  }
  return false;
}

bool AhcVfeConfigurationData::operator==(const AhcVfeConfigurationData &c) {
  return !operator!=(c);
}

std::ostream& AhcVfeConfigurationData::print(std::ostream &o, std::string s) const {
  o << s << "AhcVfeConfigurationData::print()" << std::endl;

  o << s << " Verification data = " << printHex(_verificationData) << std::endl;

  for(unsigned i(0);i<12;i++) {
    o << s << " HAB " << std::setw(2) << i << " ";
    _shiftRegister[i].print(o,s+" ");
  }
  
  return o;
}

#endif
#endif
