#ifndef CrcVlinkTrgData_HH
#define CrcVlinkTrgData_HH

#include <string>
#include <iostream>


class CrcVlinkTrgData {

public:
  enum {
    versionNumber=0
  };

  CrcVlinkTrgData();

  unsigned header() const;
  unsigned trailer(unsigned n) const;

  unsigned triggerCounter() const;

  const unsigned* data() const;

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  unsigned _header;
  unsigned _triggerCounter;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


CrcVlinkTrgData::CrcVlinkTrgData() {
  memset(this,0,sizeof(CrcVlinkTrgData));
}

unsigned CrcVlinkTrgData::header() const {
  return _header;
}

unsigned CrcVlinkTrgData::trailer(unsigned n) const {
  return *(&_header+n-1);
}

unsigned CrcVlinkTrgData::triggerCounter() const {
  return _triggerCounter;
}

const unsigned* CrcVlinkTrgData::data() const {
  return &_triggerCounter+1;
}

std::ostream& CrcVlinkTrgData::print(std::ostream &o, std::string s) const {
  o << s << "CrcVlinkTrgData::print()" << std::endl;
  o << s << " Header          = " << printHex(_header) << std::endl;
  o << s << " Trigger counter = " << std::setw(10) << _triggerCounter << std::endl;
  return o;
}

#endif
#endif
