#!/usr/local/bin/perl -w

#@INC=(/usr/local/lib/perl5/5.8.8)
#use strict;
use English;
use Tk;


#global variables

#Commands to start
my $path="/home/caliceon/online/";
my $RunTypes=$path."knownRunTypes.txt";
my $RunMonitor=$path."bin/runMonitor";
my $startUp=$path."daquser/bin/startUp";
my $shutDown=$path."bin/shutDown";
my $runStart=$path."bin/runStart";
my $runEnd=$path."bin/runEnd";


#Remote Communication

#trigger Socket
my $triggercomputer='flccalice01';
my $trigger_start_command='online/daquser/bin/startSkt';

# the run command to start
my $CommandLine;

#the logfile to tail
my $LogFile;

#have we started up ?
my $IsRunning=0;

#control sequence
my $control_running="ps -au caliceon|grep runner";

#list of simple run, basic mode 
my @RunTypeSimple=("crcNoise","emcNoise","emcBeam","emcBeamHoldScan","ahcCmNoise",
		   "ahcPmNoise","ahcCmLedVcalibScan","ahcCmLedHoldScan","ahcPmLedVcalibScan",
		   "ahcPmLedHoldScan","ahcBeam","ahcBeamHoldScan","ahcBeamStageScan",
		   "beamData","beamStageScan","cosmicsData");

#currently displayed list
my @run=@RunTypeSimple;

#to kill clean
my $Pid_RunMonitor;
my $Pid_Tail;

# option field value
my $options;

#event field value
my $events_number;

#Write switch
my $Write;

#no histogramme
my $histo;

#Expert mode switch
my $Expert;

#sockets status
my $trigger=0;
my $ecal=0;
my $hcal=0;


#
#Beginning of geometry drawing
#
#

#Main Window
my $Window=MainWindow->new(-height=>600,-width=>600);

#Window Geometry Disposition
my $LeftFrame=$Window->Frame(-relief=>"raised")->pack(-side=>"left",-expand=>1,-fill=>"both");
my $RightFrame=$Window->Frame(-relief=>"raised")->pack(-side=>"right",-expand=>1,-fill=>"both");

#Content of left Frame from top top bottom
my $StartFrame=$LeftFrame->Frame(-relief=>"raised")->pack(-side=>"top",-fill=>"x");
my $RunFrame=$LeftFrame->Frame(-relief=>"ridge")->pack(-side=>"top",-expand=>1,-fill=>"both");
my $ShutDownFrame=$LeftFrame->Frame(-relief=>"raised")->pack(-side=>"bottom",-fill=>"x");



#StartUp Frame, 1 button && 1 text
my $StartUpButton=$StartFrame->Button(-text=>"DAQ StartUp",-command=>sub{startup_prepare()})->pack(-side=>"left");
my $StartUpText=$StartFrame->Label(-text=>"Load SiPM bias Settings.\nLow Voltage MUST be on.")->pack(-side=>"right");


#Shutdown Frame, 1 button && 1status text
my $ShutDownButton=$ShutDownFrame->Button(-text=>"DAQ ShutDown",-command=>sub{shutdown_prepare()})->pack(-side=>"left");
my $ShutDownText=$ShutDownFrame->Label(-text=>"   DAQ is not running   ",
					-background=>'grey',
					-foreground=>"black")
				->pack(-side=>"right");
my $PanicButton=$ShutDownFrame->Button(-text=>"EMERGENCY",-foreground=>'red',-command=>sub{panic()})->pack(-side=>"bottom",-expand=>"1",-fill=>"x");


#RunControl Frame

#Header
my $RunIntro=$RunFrame->Label(-text=>"---\tRun Control\t---")->pack();

#RunType List
#list of possible runs with scroll bar
my $ListFrame=$RunFrame->Frame()->pack(-fill=>"both",-expand=>1);
my $RunTypeList=$ListFrame->Listbox(-selectmode=>"browse")->pack(-side=>"left",-fill=>"both",-expand=>1);
my $Scroll=$ListFrame->Scrollbar(-orient=>"v",-command=>[yview=>$RunTypeList]);
$RunTypeList->configure(-yscrollcommand=>['set',$Scroll]);
$Scroll->pack(-side=>"right",-fill=>"y",-expand=>1);


#
#prepare first Run list
#

foreach $type (@RunTypeSimple) {
	$RunTypeList->insert('end',$type);
}

my $ExpertMode=$RunFrame->Checkbutton(-text=>"Expert mode RunType List",
				      	-variable=>\$Expert,
					-command=>\&change_run_list)
			->pack();

#Write Enable button
my $WriteEnable=$RunFrame->Checkbutton(-text=>"Save data",-variable=>\$Write)->pack();
$WriteEnable->select();

#No histogram
my $HistoEnable=$RunFrame->Checkbutton(-text=>"Enable histogram output",-variable=>\$histo)->pack();
$HistoEnable->select();


#
#Run Options
#
my $OptionFrame=$RunFrame->Frame()->pack(-fill=>"x");

#Events number Field
my $EventsText=$OptionFrame->Label(-text=>"Number of Events (-e)")->pack(-side=>"left");
my $EventsField=$OptionFrame->Entry(-width=>6)->pack(-side=>"left");

#Option field
my $OptionField=$OptionFrame->Entry(-width=>3)->pack(-side=>"right");
my $OptionText=$OptionFrame->Label(-text=>"Options (-v)")->pack(-side=>"right");


#Reload DAQ settings button
my $ResetButton=$RunFrame->Button(-text=>"RELOAD HCAL DAQ SETTINGS",
				  -command=>sub{reload()},
				  -foreground=>"red")->pack();
#
# Start/Stop Run
#
my $ButtonFrame=$RunFrame->Frame()->pack(-side=>"bottom",-expand=>1,-fill=>"x");
my $StartRunButton=$RunFrame->Button(-text=>"Start Run",-command=>sub{run_start()})->pack(-side=>"left");
my $StopRunButton=$RunFrame->Button(-text=>"Stop Run",-command=>sub{run_stop()})->pack(-side=>"right");
my $runstarted=$RunFrame->Label(-text=>"No run at the moment\n")->pack(-side=>"bottom",-fill=>"x");

#
#RightFrame


#RunMonitor check

my $CheckFrame=$RightFrame->Frame()->pack(-expand=>1,-fill=>"both");
my $t;

#Log Frame

my $LogFrame=$RightFrame->Frame()->pack(-side=>"bottom",-expand=>1,-fill=>"both");
my $t2;

#
#Update RunMonitor

$Pid_RunMonitor=open(H2, "$RunMonitor|") or die "Nope: $OS_ERROR";
$t2 = $CheckFrame->Text(-width => 80, -height => 46, -wrap => 'none',-background=>"white",-font=>[-size=>9]);
$t2->pack(-expand => 1);
$CheckFrame->fileevent(H2, 'readable', [\&fill_check_widget, $t2]);


MainLoop;

open(EXIT, "kill $Pid_RunMonitor |") or die "Nope: $OS_ERROR";
if(defined($Pid_Tail)){
	open(EXIT, "kill $Pid_Tail|") or die "Nope: $OS_ERROR";
}
close(EXIT);
close(TRIGGER);
close(H);
close(H2);
close(RUNTYPES);
close(STARTUP);
close(SHUTDOWN);
close(STARTRUN);
close(STOPRUN);
close(CONTROL);

#
#
#Subroutines
#button press
#
#




#StartUp button behaviour

sub startup_prepare{

	if(!$IsRunning){
		trigger_socket();
		sleep(2);
		open(STARTUP, "$startUp|") or die "Nope: $OS_ERROR";
		do{
			$line1=<STARTUP>;	
			print $line1;
		}
		while($line1 !~ m=data/log/Log(\d+).out_Hst=);
		
		$LogFile=$path.$&;
		print $LogFile,"\t".$&."\n";
		$ShutDownText->configure(-text=>"DAQ IS running",-background=>"green",-foreground=>"black");
	
		$Pid_Tail=open(H, "tail -f $LogFile|") or die "Nope: $OS_ERROR";
		$t = $LogFrame->Text(-width => 80, -height => 25, -wrap => 'none',-background=>'white');
		$t->pack(-expand => 1);
		$LogFrame->fileevent(H, 'readable', [\&fill_log_widget, $t]);
		$IsRunning=1;
	}
	
	
}

#Shutdown button behaviour
sub shutdown_prepare{
	if($IsRunning){
		$ShutDownText->configure(-text=>"DAQ is shutting down",-background=>"yellow",-foreground=>"black");
		sleep(1);
		open(SHUTDOWN, "$shutDown|") or die "Nope: $OS_ERROR";
		my $line1=<SHUTDOWN>;
		#print $line1."\n" ;
		sleep(2);

		open(CONTROL, "$control_running|") or die "Nope: $OS_ERROR";
		$line1=<CONTROL>;
		#print $line1."\n"  ;
		if(!defined($line1) or $line1!~m/runner/){
			$LogFrame->fileevent(H, 'readable'=>'');
			$t->destroy();
			open(EXIT, "kill $Pid_Tail |") or die "Nope: $OS_ERROR";
			$Pid_Tail=undef;
			$ShutDownText->configure(-text=>"DAQ is not running",
						 -background=>"grey",
						 -foreground=>"black");
			$IsRunning=0;
			return;
		}
		$ShutDownText->configure(-text=>"DAQ is STILL  running",
						 -background=>"red",
						 -foreground=>"white");
		return;
	}
}

# emergency case# emergency case# emergency case
sub panic{
	$ShutDownText->configure(-text=>"DAQ is shutting down",-background=>"yellow",-foreground=>"black");
	open(SHUTDOWN, "panic |") or die "Nope: $OS_ERROR";
	my $line1=<SHUTDOWN>;
	$ShutDownText->configure(-text=>"DAQ is not running",
						 -background=>"grey",
						 -foreground=>"black");
	$IsRunning=0;
	return;
}
#Expert mode switch behaviour
sub change_run_list{
	$RunTypeList->delete(0,'end');
	@run=();
	if($Expert){
		open(RUNTYPES, "<$RunTypes") or die "Nope: $OS_ERROR";
		while(defined($line1=<RUNTYPES>)){
			$line1=~ m/\s+Type\s+=\s+\d+\s+=\s+(\w+),/;
			$RunTypeList->insert('end',$1);
			push @run,$1;
		}
	}
	else{
		foreach $type (@RunTypeSimple){
			$RunTypeList->insert('end',$type);
		}
		@run=@RunTypeSimple;
	}

}


#RunStart button behaviour
sub run_start{

	if(!$IsRunning){
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
	}else{
		$CommandLine=$runStart." ";
		if(!$Write){
			$CommandLine=$CommandLine."-w ";
		}
		if(!$histo){
			$CommandLine=$CommandLine."-d ";
		}
		if($options=$OptionField->get()){
			$CommandLine=$CommandLine."-v $options ";
		}
		if($events_number=$EventsField->get()){
			$CommandLine=$CommandLine."-e $events_number ";
		}
		my ($runtype)=$RunTypeList->curselection();
		if(!defined($runtype)){
			return;
		}
		$CommandLine=$CommandLine."-t $run[$runtype] ";
		open(STARTRUN, "$CommandLine|") or die "Nope: $OS_ERROR";
		$runstarted->configure(-text=>"The following run has started\n$CommandLine",-background=>'green');
	}

}

#RunStop button behaviour
sub run_stop{
	if(!$IsRunning){
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
	}else{
		open(STOPRUN, "$runEnd|") or die "Nope: $OS_ERROR";
		close(STOPRUN);
		$runstarted->configure(-text=>"No run at the moment\n",-background=>'grey');
	}
}

#Reload settings button behaviour
sub reload{
	if(!$IsRunning){
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
		sleep(1);
		$ShutDownText->configure(-background=>"red");
		sleep(1);
		$ShutDownText->configure(-background=>"white");
	}else{
		open(RUNTYPES, "$runStart -t ahcDacScan") or die "Nope: $OS_ERROR";
	}
}




#Open Trigger socket  button


sub trigger_socket {
		open(TRIGGER,"ssh ".$triggercomputer." ".$trigger_start_command ." |") or die "Nope: $OS_ERROR";
}



#Update log tail frame
sub fill_log_widget {

    my($widget) = @ARG;

    $ARG = <H>;
    $widget->insert('end', $ARG);
    $widget->yview('end');
} # end fill_text_widget 



#Update RunMonitor frame
sub fill_check_widget {

    my($widget) = @ARG;

    $ARG = <H2>;
    $widget->insert('end', $ARG);
    $widget->yview('end');
} # end fill_text_widget 
