#ifndef RunCount_HH
#define RunCount_HH

#include <sys/types.h>
#include <unistd.h>
#include <time.h>

#include "RcdCount.hh"


class RunCount {

public:
  //enum {
  //  shmKey=0x76543213
  //};

  RunCount() {
  }

  void increment(const RcdRecord &r) {

    // Count everything
    if(r.recordType()==RcdHeader::startUp) {
      _header[0]=(RcdHeader)r;
      _count[0].reset();
    }
    _count[0]+=r;

    // Count the current sequence
    if(r.recordType()==RcdHeader::startUp ||
       r.recordType()==RcdHeader::sequenceStart) {
      _count[1].reset();
       if(r.recordType()==RcdHeader::sequenceStart) _header[1]=(RcdHeader)r;
    }

    if(r.recordType()!=RcdHeader::startUp && 
       r.recordType()!=RcdHeader::shutDown) _count[1]+=r;

    // Count the current run
    if(r.recordType()==RcdHeader::startUp       ||
       r.recordType()==RcdHeader::sequenceStart ||
       r.recordType()==RcdHeader::runStart) {
      _count[2].reset();
       if(r.recordType()==RcdHeader::runStart) _header[2]=(RcdHeader)r;
    }

    if(r.recordType()!=RcdHeader::startUp       && 
       r.recordType()!=RcdHeader::sequenceStart &&
       r.recordType()!=RcdHeader::sequenceEnd   &&
       r.recordType()!=RcdHeader::shutDown) _count[2]+=r;

    // Count the current configuration
    if(r.recordType()==RcdHeader::startUp       ||
       r.recordType()==RcdHeader::sequenceStart ||
       r.recordType()==RcdHeader::runStart      ||
       r.recordType()==RcdHeader::configurationStart) {
      _count[3].reset();
      if(r.recordType()==RcdHeader::configurationStart) _header[3]=(RcdHeader)r;
    }

    if(r.recordType()!=RcdHeader::startUp       && 
       r.recordType()!=RcdHeader::sequenceStart &&
       r.recordType()!=RcdHeader::runStart      &&
       r.recordType()!=RcdHeader::runEnd        &&
       r.recordType()!=RcdHeader::sequenceEnd   &&
       r.recordType()!=RcdHeader::shutDown) _count[3]+=r;

    // Count the current acquisition
    if(r.recordType()==RcdHeader::startUp            ||
       r.recordType()==RcdHeader::runStart           ||
       r.recordType()==RcdHeader::sequenceStart      ||
       r.recordType()==RcdHeader::configurationStart ||
       r.recordType()==RcdHeader::acquisitionStart) {
      _count[4].reset();
      if(r.recordType()==RcdHeader::acquisitionStart) _header[4]=(RcdHeader)r;
    }

    if(r.recordType()!=RcdHeader::startUp            && 
       r.recordType()!=RcdHeader::sequenceStart      &&
       r.recordType()!=RcdHeader::runStart           &&
       r.recordType()!=RcdHeader::configurationStart &&
       r.recordType()!=RcdHeader::configurationEnd   &&
       r.recordType()!=RcdHeader::runEnd             &&
       r.recordType()!=RcdHeader::sequenceEnd        &&
       r.recordType()!=RcdHeader::slowReadout        &&
       r.recordType()!=RcdHeader::shutDown) _count[4]+=r;

    // Last headers
    if(r.recordType()!=RcdHeader::trigger &&
       r.recordType()!=RcdHeader::event) _header[5]=(RcdHeader)r;
    _header[6]=(RcdHeader)r;
  }

  unsigned count(RcdHeader::RecordType t=RcdHeader::event, unsigned j=0) const {
    assert(j<4);
    return _count[j].count(t);
  }

  RcdHeader header(unsigned i) const {
    assert(i<7);
    return _header[i];
  }

  std::ostream& print(std::ostream& o, std::string s="") const {
    o << s << "RunCount::print()" << std::endl;

    _header[0].print(o,s+" Job  ");
    _count[0].print(o,s+" Job  ") << std::endl;

    //_header[1].print(o,s+" Seq  ");
    //_count[1].print(o,s+" Seq  ") << std::endl;

    _header[2].print(o,s+" Run  ");
    _count[2].print(o,s+" Run  ") << std::endl;

    _header[3].print(o,s+" Cfg  ");
    _count[3].print(o,s+" Cfg  ") << std::endl;

    _header[4].print(o,s+" Acq  ");
    _count[4].print(o,s+" Acq  ") << std::endl;

    _header[5].print(o,s+" Last ");
    //if(_header[5]!=_header[6])
      _header[6].print(o,s+" Last ");

    return o;
  }

private:
  RcdHeader _header[7];
  RcdCount _count[5];
};

#endif
