void HstCrcSlow(unsigned bits=0xffffffff) {

   // Histogram consumer script. Create a canvas and 3 pads. Connect
   // to memory mapped file "hsimple.map", that was created by hprod.C.
   // It reads the histograms from shared memory and displays them
   // in the pads (sleeping for 0.1 seconds before starting a new read-out
   // cycle). This script runs in an infinite loop, so use ctrl-c to stop it.

   gROOT->Reset();

   // Open the memory mapped file "hsimple.map" in "READ" (default) mode.
   mfile = TMapFile::Create("HstGeneric.map");

   // Print status of mapped file and list its contents
   mfile->Print();
   mfile->ls();

   // Create a new canvas and 3 pads
   TCanvas *HstCrcSlowCanvas[22];

   // Create pointers to the objects in shared memory.
   TH1F *_hstCrcNoiseNumber[22];
   TH1F *_hstCrcNoisePedestal[22];
   TH1F *_hstCrcNoiseNoise[22];
   ostringstream sout[22];

   for(unsigned i(0);i<22;i++) {
     if((bits&(1<<i))!=0) {
       if(i<10) sout[i] << "0";
       sout[i] << i;

       _hstCrcNoiseNumber[i]=(TH1F*)mfile->Get((string("HstCrcSlowNumber")+sout[i].str()).c_str());
       if(_hstCrcNoiseNumber[i]!=0) {
	 HstCrcSlowCanvas[i]=new 
	   TCanvas((string("HstCrcSlowCanvas")+sout[i].str()).c_str(),
		   (string("HstCrcSlow")+sout[i].str()).c_str(),
		   200+10*i,10+10*i,700,780);
	 HstCrcSlowCanvas[i]->Divide(1,3);
       }
     }
   }

   // Loop displaying the histograms. Once the producer stops this
   // script will break out of the loop.
   while (true) {
     for(unsigned i(0);i<22;i++) {
       if((bits&(1<<i))!=0 && HstCrcSlowCanvas[i]!=0) {
	 _hstCrcNoiseNumber[i]  =(TH1F*)mfile->Get((string("HstCrcSlowNumber")  +sout[i].str()).c_str());
	 _hstCrcNoisePedestal[i]=(TH1F*)mfile->Get((string("HstCrcSlowPedestal")+sout[i].str()).c_str());
	 _hstCrcNoiseNoise[i]   =(TH1F*)mfile->Get((string("HstCrcSlowNoise")   +sout[i].str()).c_str());
     
	 HstCrcSlowCanvas[i]->cd(1);
	 if(_hstCrcNoiseNumber[i]!=0) _hstCrcNoiseNumber[i]->Draw();
	 HstCrcSlowCanvas[i]->cd(2);
	 if(_hstCrcNoisePedestal[i]!=0) _hstCrcNoisePedestal[i]->Draw();
	 HstCrcSlowCanvas[i]->cd(3);
	 if(_hstCrcNoiseNoise[i]!=0) _hstCrcNoiseNoise[i]->Draw();
	 
	 HstCrcSlowCanvas[i]->Modified();
	 HstCrcSlowCanvas[i]->Update();
       }
     }

     gSystem->Sleep(1000);   // sleep for 0.1 seconds
     if (gSystem->ProcessEvents()) break;
   }
}
