#include <iostream>
#include <sstream>

#include "UtlArguments.hh"
#include "RcdArena.hh"
#include "RcdReaderBin.hh"
#include "RcdWriterSkt.hh"

using namespace std;

int main(int argc, const char **argv) {
  UtlArguments argh(argc,argv);
  argh.print(cout);
  const unsigned runNumber(argh.lastArgument(999999));
  
  RcdArena arena;
  RcdReaderBin reader;
  RcdWriterSkt writer;

  ostringstream sout;
  sout << "data/dat/Run" << runNumber;

  reader.open(sout.str());
  writer.open("some socket");

  while(reader.read(arena) && writer.write(arena));

  reader.close();
  writer.close();
}
