#ifndef IlcConfiguration_HH
#define IlcConfiguration_HH

#include <vector>
#include <fstream>
#include <iostream>

#include "RcdUserRW.hh"

#include "SubInserter.hh"
#include "SubAccessor.hh"

#include "IlcRunStart.hh"
#include "IlcRunEnd.hh"
#include "IlcConfigurationStart.hh"
#include "IlcConfigurationEnd.hh"
#include "IlcBunchTrain.hh"

//#include "DaqRunNumber.hh"


class IlcConfiguration : public RcdUserRW {

public:
  enum Counter {
    rInJ,
    cInR,
    bInR,bInC,
    endOfCounterEnum
  };

  IlcConfiguration() {
  }
  /*
    IlcConfiguration() :
    _shmRunControl(RunControl::shmKey), _pRc(_shmRunControl.payload()) {
    assert(_pRc!=0);
    }
  */

  virtual ~IlcConfiguration() {
  }

  IlcRunStart runStart() const {
    return _runStartFromRunControl;
  }

  void runStart(IlcRunStart r) {
    _runStartFromRunControl=r;
    assert(_runStartFromRunControl.runType().knownType());
  }

  bool record(RcdRecord &r) {
    if(doPrint(r.recordType())) {
      std::cout << "IlcConfiguration::record()" << std::endl;
      r.RcdHeader::print(std::cout," ") << std::endl;
    }
 
    SubInserter inserter(r);

    UtlPack tid;
    tid.halfWord(1,SubHeader::daq);
    tid.byte(2,0);

    DaqTwoTimer *t(inserter.insert<DaqTwoTimer>(true));
    t->timerId(tid.word());


    // Check record type
    switch (r.recordType()) {

    case RcdHeader::startUp: {
      _count[rInJ]=0;
      
      /*
	SubAccessor accessor(r);
	std::vector<const DaqStartUp*> v(accessor.extract<DaqStartUp>());
	assert(v.size()<=1);

	_runType=IlcRunType(IlcRunType::daq,IlcRunType::daqTest,0);

	if(v.size()==1) {
	if(_printLevel>0) v[0]->print(std::cout," ") << std::endl;
	_runType=v[0]->runType();
	}

	assert(_runType.knownType());
      */
     
      break;
    }
      
    case RcdHeader::runStart: {
      _count[cInR]=0; //c
      _count[bInR]=0; //b

      SubInserter inserter(r);
      IlcRunStart *d(inserter.insert<IlcRunStart>(true));

      //_runStartFromRunControl=_pRc->runStart();
      //_pRc->reset();

      if(_runStartFromRunControl.runType().writeRun()) {
	_runNumber=daqReadRunNumber();
	daqWriteRunNumber(_runNumber+1);
      } else {
	_runNumber=r.recordTime().seconds();
      }

      d->runNumber(_runNumber);
      d->runType(_runStartFromRunControl.runType());
      setRun(*d);
      
      if(doPrint(r.recordType(),1)) d->print(std::cout," ") << std::endl;
      
      break;
    }
      
    case RcdHeader::configurationStart: {
      _count[bInC]=0; //b
          
      _daqConfigurationStart.reset();
      _daqConfigurationStart.configurationNumberInRun(_count[cInR]);
      setConfiguration(_daqConfigurationStart);
     
      SubInserter inserter(r);
      inserter.insert<IlcConfigurationStart>(_daqConfigurationStart);
    
      _count[cInR]++;
     
      if(doPrint(r.recordType(),1)) _daqConfigurationStart.print(std::cout," ") << std::endl;
      
      break;
    }

    case RcdHeader::bunchTrain: {
      SubInserter inserter(r);
      IlcBunchTrain *d(inserter.insert<IlcBunchTrain>(true));
      
      d->bunchTrainNumberInRun(_count[bInR]);
      d->bunchTrainNumberInConfiguration(_count[bInC]);
      
      _count[bInR]++;
      _count[bInC]++;

      if(doPrint(r.recordType(),1)) d->print(std::cout," ") << std::endl;
      
      break;
    }
      
    default: {
      break;
    }
    };

    // Close off overall timer
    t->setEndTime();
    if(doPrint(r.recordType())) t->print(std::cout," ") << std::endl;

    return true;
  }


  virtual void setRun(IlcRunStart &d) const {
    //const unsigned char v(_runStartFromRunControl.runType().version());

    const UtlPack v(_runStartFromRunControl.runType().version());

    switch(_runStartFromRunControl.runType().type()) {

    case IlcRunType::slwMonitor: {
      break;
    }

    case IlcRunType::mpsTest: {
      break;
    }
    case IlcRunType::mpsExpert: {
      break;
    }
    case IlcRunType::mpsNoise: {
      break;
    }
    case IlcRunType::mpsConfigurationTest: {
      break;
    }
    case IlcRunType::mpsThreshold: {
      break;
    }
    case IlcRunType::mpsThresholdScan: {
      d.maximumNumberOfConfigurationsInRun(v.word()+1);
      break;
    }
    case IlcRunType::mpsTrim: {
      break;
    }
    case IlcRunType::mpsTrimScan: {
      d.maximumNumberOfConfigurationsInRun(16);
      break;
    }
    case IlcRunType::mpsBeam: {
      break;
    }
    case IlcRunType::mpsCosmics: {
      break;
    }
    case IlcRunType::mpsSource: {
      break;
    }
    case IlcRunType::mpsLaser: {
      break;
    }
    case IlcRunType::mpsLaserPosition: {
      break;
    }
    case IlcRunType::mpsLaserPositionScan: {
      d.maximumNumberOfConfigurationsInRun((v.word()+1)*(v.word()+1));
      break;
    }
    case IlcRunType::mpsLaserThreshold: {
      break;
    }
    case IlcRunType::mpsLaserThresholdScan: {
      d.maximumNumberOfConfigurationsInRun(v.word()+1);
      break;
    }

    default: {
      // We missed a run type
      assert(false);
      break;
    }
    };

    // Reset limits if smaller from run control
    if(d.maximumNumberOfConfigurationsInRun()>
       _runStartFromRunControl.maximumNumberOfConfigurationsInRun())
      d.maximumNumberOfConfigurationsInRun(_runStartFromRunControl.maximumNumberOfConfigurationsInRun());

    if(d.maximumNumberOfBunchTrainsInRun()>
       _runStartFromRunControl.maximumNumberOfBunchTrainsInRun())
      d.maximumNumberOfBunchTrainsInRun(_runStartFromRunControl.maximumNumberOfBunchTrainsInRun());

    if(d.maximumTimeOfRun()>
       _runStartFromRunControl.maximumTimeOfRun())
      d.maximumTimeOfRun(_runStartFromRunControl.maximumTimeOfRun());
  }

  virtual void setConfiguration(IlcConfigurationStart &d) const {
    //const unsigned iCfg(d.configurationNumberInRun());

    //const UtlPack v(_runStartFromRunControl.runType().version());

    // Overall defaults
    d.maximumTimeOfConfiguration(UtlTimeDifference(60*60)); // 1hour
    
    // Select on run type
    switch(_runStartFromRunControl.runType().type()) {

    case IlcRunType::slwMonitor: {
      break;
    }

    case IlcRunType::mpsTest: {
      break;
    }
    case IlcRunType::mpsExpert: {
      break;
    }
    case IlcRunType::mpsNoise: {
      break;
    }
    case IlcRunType::mpsConfigurationTest: {
      d.maximumNumberOfBunchTrainsInConfiguration(0);
      break;
    }
    case IlcRunType::mpsThreshold: {
      break;
    }
    case IlcRunType::mpsThresholdScan: {
      d.maximumNumberOfBunchTrainsInConfiguration(100);
      break;
    }
    case IlcRunType::mpsTrim: {
      break;
    }
    case IlcRunType::mpsTrimScan: {
      d.maximumNumberOfBunchTrainsInConfiguration(100);
      break;
    }
    case IlcRunType::mpsBeam: {
      break;
    }
    case IlcRunType::mpsCosmics: {
      break;
    }
    case IlcRunType::mpsSource: {
      break;
    }
    case IlcRunType::mpsLaser: {
      break;
    }
    case IlcRunType::mpsLaserPosition: {
      break;
    }
    case IlcRunType::mpsLaserPositionScan: {
      d.maximumNumberOfBunchTrainsInConfiguration(200);
      break;
    }
    case IlcRunType::mpsLaserThreshold: {
      break;
    }
    case IlcRunType::mpsLaserThresholdScan: {
      d.maximumNumberOfBunchTrainsInConfiguration(100);
      break;
    }

    default: {
      // We missed a run type
      assert(false);
      break;
    }
    };
  }


protected:
  IlcRunStart _runStartFromRunControl;

private:
  unsigned _runNumber;
  IlcConfigurationStart _daqConfigurationStart;
  unsigned _count[endOfCounterEnum];

  /*
    ShmObject<RunControl> _shmRunControl;
    RunControl *_pRc;
  */
};

#endif
