#ifndef MpsPcb1BunchTrainData_HH
#define MpsPcb1BunchTrainData_HH

#include <iostream>
#include <fstream>


class MpsPcb1BunchTrainData {

public:
  enum {
    versionNumber=0
  };

  MpsPcb1BunchTrainData();

  unsigned temperature() const;
  void     temperature(unsigned n);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  unsigned _temperature;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsPcb1BunchTrainData::MpsPcb1BunchTrainData() {
  memset(this,0,sizeof(MpsPcb1BunchTrainData));
}

unsigned MpsPcb1BunchTrainData::temperature() const {
  return _temperature;
}

void MpsPcb1BunchTrainData::temperature(unsigned n) {
  _temperature=n;
}

std::ostream& MpsPcb1BunchTrainData::print(std::ostream &o, std::string s) const {
  o << s << "MpsPcb1BunchTrainData::print()" << std::endl;
  o << s << " Temperature = " << temperature() << " C" << std::endl;

  return o;
}

#endif
#endif
