#ifndef MpsUsbDaqConfigurationData_HH
#define MpsUsbDaqConfigurationData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class MpsUsbDaqConfigurationData {

public:
  enum {
    versionNumber=0
  };

  MpsUsbDaqConfigurationData();

  bool master() const;
  void master(bool b);

  bool externalStart() const;
  void externalStart(bool b);

  bool externalLaserStart() const;
  void externalLaserStart(bool b);

  bool fireLaser() const;
  void fireLaser(bool b);

  bool retryStart() const;
  void retryStart(bool b);

  unsigned triggerMask() const;
  void     triggerMask(unsigned n);

  unsigned triggerCondition() const;
  void     triggerCondition(unsigned n);

  unsigned externalTimeout() const;
  void     externalTimeout(unsigned n);

  unsigned numberOfRetries() const;
  void     numberOfRetries(unsigned n);

  unsigned timer(unsigned n) const;
  void     timer(unsigned n, unsigned t);

  unsigned numberOfBunchCrossings() const;
  void     numberOfBunchCrossings(unsigned n);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  UtlPack _data;
  u_int32_t _triggerMask;
  u_int32_t _triggerCondition;
  u_int32_t _externalTimeout;
  u_int32_t _numberOfRetries;
  u_int32_t _timer[32];
  u_int32_t _numberOfBunchCrossings;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsUsbDaqConfigurationData::MpsUsbDaqConfigurationData() {
  memset(this,0,sizeof(MpsUsbDaqConfigurationData));
  _numberOfBunchCrossings=8192;
}

bool MpsUsbDaqConfigurationData::master() const {
  return _data.bit(0);
}

void MpsUsbDaqConfigurationData::master(bool b) {
  _data.bit(0,b);
}

bool MpsUsbDaqConfigurationData::externalStart() const {
  return _data.bit(1);
}

void MpsUsbDaqConfigurationData::externalStart(bool b) {
  _data.bit(1,b);
}

bool MpsUsbDaqConfigurationData::externalLaserStart() const {
  return _data.bit(2);
}

void MpsUsbDaqConfigurationData::externalLaserStart(bool b) {
  _data.bit(2,b);
}

bool MpsUsbDaqConfigurationData::fireLaser() const {
  return _data.bit(3);
}

void MpsUsbDaqConfigurationData::fireLaser(bool b) {
  _data.bit(3,b);
}

bool MpsUsbDaqConfigurationData::retryStart() const {
  return _data.bit(4);
}

void MpsUsbDaqConfigurationData::retryStart(bool b) {
  _data.bit(4,b);
}

unsigned MpsUsbDaqConfigurationData::triggerMask() const {
  return _triggerMask;
}

void MpsUsbDaqConfigurationData::triggerMask(unsigned n) {
  _triggerMask=n;
}

unsigned MpsUsbDaqConfigurationData::triggerCondition() const {
  return _triggerCondition;
}

void MpsUsbDaqConfigurationData::triggerCondition(unsigned n) {
  _triggerCondition=n;
}

unsigned MpsUsbDaqConfigurationData::externalTimeout() const {
  return _externalTimeout;
}

void MpsUsbDaqConfigurationData::externalTimeout(unsigned n) {
  _externalTimeout=n;
}

unsigned MpsUsbDaqConfigurationData::numberOfRetries() const {
  return _numberOfRetries;
}

void MpsUsbDaqConfigurationData::numberOfRetries(unsigned n) {
  _numberOfRetries=n;
}

unsigned MpsUsbDaqConfigurationData::timer(unsigned n) const {
  assert(n<32);
  return _timer[n];
}

void MpsUsbDaqConfigurationData::timer(unsigned n, unsigned t) {
  assert(n<32);
  _timer[n]=t;
}

unsigned MpsUsbDaqConfigurationData::numberOfBunchCrossings() const {
  return _numberOfBunchCrossings;
}

void MpsUsbDaqConfigurationData::numberOfBunchCrossings(unsigned n) {
  _numberOfBunchCrossings=n;
}

std::ostream& MpsUsbDaqConfigurationData::print(std::ostream &o, std::string s) const {
  o << s << "MpsUsbDaqConfigurationData::print()" << std::endl;
  o << s << " Data = " << printHex(_data.word()) << std::endl;
  o << s << " Number of bunch crossings = " << _numberOfBunchCrossings << std::endl;
  return o;
}

#endif
#endif
