#include <iostream>
#include <sstream>
#include <vector>

#include "UtlArguments.hh"
#include "RcdArena.hh"
#include "RcdCount.hh"
#include "RunReader.hh"
#include "SubAccessor.hh"

#include "MpsAnalysis.hh"

using namespace std;


int main(int argc, const char **argv) {

  // Get run number as last (=only) argument
  UtlArguments argh(argc,argv);
  const unsigned runnum(argh.lastArgument(999999));

  if(runnum==999999) {
    cout << "Usage: " << argv[0] << " <run number>" << endl;
    return 1;
  }

  // Define memory space for records
  RcdArena arena;

  // Open run file using reader
  // This can handle both single-file and multi-file runs
  RunReader reader;
  assert(reader.open(runnum));

  // Create simple record type counter
  RcdCount counter;

  // Create MAPS analysis module
  MpsAnalysis analysis;

  // Loop over all records until end-of-file
  while(reader.read(arena)) {

    // Increment counter
    counter+=arena;

    // Run analysis
    analysis.record(arena);
  }

  // Close run file
  assert(reader.close());

  // Print total of counts
  cout << endl;
  counter.print(cout);

  return 0;
}
