#ifndef MpsPcb1ConfigurationData_HH
#define MpsPcb1ConfigurationData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class MpsPcb1ConfigurationData {

public:
  enum {
    versionNumber=0
  };

  MpsPcb1ConfigurationData();

  unsigned dac(unsigned n) const;
  void     dac(unsigned n, unsigned d);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  UtlPack _dac[16];
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsPcb1ConfigurationData::MpsPcb1ConfigurationData() {
  memset(this,0,sizeof(MpsPcb1ConfigurationData));
  for(unsigned i(0);i<1;i++) {
    dac(i,0x0800);
  }
}

unsigned MpsPcb1ConfigurationData::dac(unsigned n) const {
  assert(n<32);
  return _dac[n/2].halfWord(n%2);
}

void MpsPcb1ConfigurationData::dac(unsigned n, unsigned d) {
  assert(n<32);
  assert(d<0x1000);
  _dac[n/2].halfWord(n%2,d);
}

std::ostream& MpsPcb1ConfigurationData::print(std::ostream &o, std::string s) const {
  o << s << "MpsPcb1ConfigurationData::print()" << std::endl;

  for(unsigned i(0);i<4;i++) {
    o << s << " DACs " << std::setw(2) << 8*i << "-"
      << std::setw(2) << 8*i+7 << " =";

    for(unsigned j(8*i);j<8*(i+1);j++) {
      o << std::setw(6) << dac(j);
    }
    
    o << std::endl;
  }
  
  return o;
}

#endif
#endif
