#ifndef MpsSensor1BunchTrainData_HH
#define MpsSensor1BunchTrainData_HH

#include <iostream>
#include <fstream>

#include "MpsSensor1Hit.hh"
#include "MpsSensor1BunchTrainDatum.hh"


class MpsSensor1BunchTrainData {

public:
  enum {
    versionNumber=0
  };

  MpsSensor1BunchTrainData();

  unsigned finalBits() const;
  void     finalBits(unsigned n);

  unsigned totalNumberOfHits() const;
  unsigned numberOfRegionHits(unsigned g) const;
  void     numberOfRegionHits(unsigned g, unsigned n);

  const MpsSensor1BunchTrainDatum* data() const;
        MpsSensor1BunchTrainDatum* data();

  std::vector<MpsSensor1Hit> hitVector() const;
  void                       hitVector(const std::vector<MpsSensor1Hit> &v);

  std::vector<MpsSensor1Hit> fullVector() const;

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  UtlPack _finalBits;
  unsigned _numberOfRegionHits[4];
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsSensor1BunchTrainData::MpsSensor1BunchTrainData() {
  memset(this,0,sizeof(MpsSensor1BunchTrainData));
}

unsigned MpsSensor1BunchTrainData::finalBits() const {
  return _finalBits.word();
}

void MpsSensor1BunchTrainData::finalBits(unsigned n) {
  _finalBits=n;
}

unsigned MpsSensor1BunchTrainData::totalNumberOfHits() const {
  return
    _numberOfRegionHits[0]+_numberOfRegionHits[1]+
    _numberOfRegionHits[2]+_numberOfRegionHits[3];
}

unsigned MpsSensor1BunchTrainData::numberOfRegionHits(unsigned g) const {
  assert(g<4);
  return _numberOfRegionHits[g];
}

void MpsSensor1BunchTrainData::numberOfRegionHits(unsigned g, unsigned n) {
  assert(g<4);
  _numberOfRegionHits[g]=n;
}

std::vector<MpsSensor1Hit> MpsSensor1BunchTrainData::hitVector() const {
  std::vector<MpsSensor1Hit> v;

  const MpsSensor1BunchTrainDatum *p(data());
  for(unsigned region(0);region<4;region++) {
    for(unsigned i(0);i<_numberOfRegionHits[region];i++) {
      for(unsigned c(0);c<6;c++) {
	if(p->channel(c)) {
	  MpsSensor1Hit hit;
	  hit.pixelX(c+6*p->group()+42*region);
	  hit.pixelY(p->row());
	  hit.timeStamp(p->timeStamp());
	  v.push_back(hit);
	}
      }

      p++;
    }
  }
  return v;
}

void MpsSensor1BunchTrainData::hitVector(const std::vector<MpsSensor1Hit> &v) {
  _numberOfRegionHits[0]=0;
  _numberOfRegionHits[1]=0;
  _numberOfRegionHits[2]=0;
  _numberOfRegionHits[3]=0;

  MpsSensor1BunchTrainDatum *p(data());
  for(unsigned i(0);i<v.size();i++) {
    unsigned region(v[i].pixelX()/42);
    _numberOfRegionHits[region]++;

    p[i].group(((v[i].pixelX())%42)/6);
    p[i].channel(((v[i].pixelX())%42)%6,true);
    p[i].row(v[i].pixelY());
    p[i].timeStamp(v[i].timeStamp());
  }

  assert(v.size()==totalNumberOfHits());
}

std::vector<MpsSensor1Hit> MpsSensor1BunchTrainData::fullVector() const {
  std::vector<MpsSensor1Hit> v;

  const MpsSensor1BunchTrainDatum *p(data());
  for(unsigned region(0);region<4;region++) {
    unsigned groupCount[168][7];
    memset(groupCount[0],0,168*7*sizeof(unsigned));

    for(unsigned i(0);i<_numberOfRegionHits[region];i++) {
      groupCount[p->row()][p->group()]++;
      if(groupCount[p->row()][p->group()]>=19) {
	for(unsigned c(0);c<6;c++) {
	  MpsSensor1Hit hit;
	  hit.pixelX(c+6*p->group()+42*region);
	  hit.pixelY(p->row());
	  hit.timeStamp(p->timeStamp()+1);
	  v.push_back(hit);
	}
      }

      p++;
    }
  }
  return v;
}

const MpsSensor1BunchTrainDatum* MpsSensor1BunchTrainData::data() const {
  return (const MpsSensor1BunchTrainDatum*)(this+1);
}

MpsSensor1BunchTrainDatum* MpsSensor1BunchTrainData::data() {
  return (MpsSensor1BunchTrainDatum*)(this+1);
}

std::ostream& MpsSensor1BunchTrainData::print(std::ostream &o, std::string s) const {
  o << s << "MpsSensor1BunchTrainData::print()" << std::endl;
  o << s << " Final bit status = " << printHex(_finalBits) << std::endl;
  o << s << " Total number of hits = " << totalNumberOfHits() << std::endl;

  /*  
  if(numberOfRegionHits()>0) {
    for(unsigned i(0);i<4;i++) {
      o << s << " Column " << i << " , number of hits = "
	<< numberOfColumnHits(i) << std::endl;
      
      const unsigned *p((unsigned*)columnData(i));
      for(unsigned j(0);j<numberOfColumnHits(i);j++) {
      o << s << "  Hit " << std::setw(3) << " = "
	<< printHex(p[i]) << std::endl;
      }
    }
  }
  */
  /*
  const MpsSensor1Hit *p((const MpsSensor1Hit*)(this+1));
  for(unsigned i(0);i<_numberOfRegionHits;i++) {
    p[i].print(o,s+"  ");
  }
  */

  return o;
}

#endif
#endif
